/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10.extensions;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v5_10.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v5_10.extensions.DeploymentFluentImpl;
import java.util.Objects;

public class DeploymentBuilder
extends DeploymentFluentImpl<DeploymentBuilder>
implements VisitableBuilder<Deployment, DeploymentBuilder> {
    DeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentBuilder() {
        this(false);
    }

    public DeploymentBuilder(Boolean validationEnabled) {
        this(new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance) {
        this(fluent, instance, false);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentBuilder(Deployment instance) {
        this(instance, (Boolean)false);
    }

    public DeploymentBuilder(Deployment instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Deployment build() {
        Deployment buildable = new Deployment(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentBuilder that = (DeploymentBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

