/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceCondition;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceConditionBuilder;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceStatus;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceStatusFluentImpl<A extends NamespaceStatusFluent<A>>
extends BaseFluent<A>
implements NamespaceStatusFluent<A> {
    private List<NamespaceConditionBuilder> conditions = new ArrayList<NamespaceConditionBuilder>();
    private String phase;
    private Map<String, Object> additionalProperties;

    public NamespaceStatusFluentImpl() {
    }

    public NamespaceStatusFluentImpl(NamespaceStatus instance) {
        this.withConditions(instance.getConditions());
        this.withPhase(instance.getPhase());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceConditionBuilder>();
        }
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, NamespaceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceConditionBuilder>();
        }
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(NamespaceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceConditionBuilder>();
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NamespaceConditionBuilder>();
        }
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(NamespaceCondition ... items) {
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<NamespaceCondition> items) {
        for (NamespaceCondition item : items) {
            NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<NamespaceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<NamespaceConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            NamespaceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamespaceCondition> getConditions() {
        return NamespaceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<NamespaceCondition> buildConditions() {
        return NamespaceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public NamespaceCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public NamespaceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public NamespaceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public NamespaceCondition buildMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<NamespaceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<NamespaceConditionBuilder>();
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(NamespaceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (NamespaceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(NamespaceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, NamespaceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    @Deprecated
    public A withNewPhase(String arg0) {
        return this.withPhase(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceStatusFluentImpl that = (NamespaceStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.phase, this.additionalProperties, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends NamespaceConditionFluentImpl<NamespaceStatusFluent.ConditionsNested<N>>
    implements NamespaceStatusFluent.ConditionsNested<N>,
    Nested<N> {
        NamespaceConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, NamespaceCondition item) {
            this.index = index;
            this.builder = new NamespaceConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new NamespaceConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamespaceStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

