/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceSpec;
import io.fabric8.kubernetes.api.model.v5_10.NamespaceSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamespaceSpecFluentImpl<A extends NamespaceSpecFluent<A>>
extends BaseFluent<A>
implements NamespaceSpecFluent<A> {
    private List<String> finalizers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NamespaceSpecFluentImpl() {
    }

    public NamespaceSpecFluentImpl(NamespaceSpec instance) {
        this.withFinalizers(instance.getFinalizers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToFinalizers(Integer index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(Integer index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(Integer index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public A addNewFinalizer(String arg0) {
        return this.addToFinalizers(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceSpecFluentImpl that = (NamespaceSpecFluentImpl)o;
        if (this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.finalizers, this.additionalProperties, super.hashCode());
    }
}

