/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.AuthInfo;
import io.fabric8.kubernetes.api.model.v5_10.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.v5_10.AuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.v5_10.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v5_10.NamedAuthInfoFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>>
extends BaseFluent<A>
implements NamedAuthInfoFluent<A> {
    private String name;
    private AuthInfoBuilder user;
    private Map<String, Object> additionalProperties;

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        this.withName(instance.getName());
        this.withUser(instance.getUser());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    @Deprecated
    public AuthInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public AuthInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(AuthInfo user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new AuthInfoBuilder().build());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUserLike(AuthInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.user, this.additionalProperties, super.hashCode());
    }

    public class UserNestedImpl<N>
    extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>>
    implements NamedAuthInfoFluent.UserNested<N>,
    Nested<N> {
        AuthInfoBuilder builder;

        UserNestedImpl(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new AuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedAuthInfoFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

