/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.EndpointSubset;
import io.fabric8.kubernetes.api.model.v5_10.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.v5_10.EndpointSubsetFluentImpl;
import java.util.Objects;

public class EndpointSubsetBuilder
extends EndpointSubsetFluentImpl<EndpointSubsetBuilder>
implements VisitableBuilder<EndpointSubset, EndpointSubsetBuilder> {
    EndpointSubsetFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSubsetBuilder() {
        this(false);
    }

    public EndpointSubsetBuilder(Boolean validationEnabled) {
        this(new EndpointSubset(), validationEnabled);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointSubset(), validationEnabled);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, EndpointSubset instance) {
        this(fluent, instance, false);
    }

    public EndpointSubsetBuilder(EndpointSubsetFluent<?> fluent, EndpointSubset instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withNotReadyAddresses(instance.getNotReadyAddresses());
        fluent.withPorts(instance.getPorts());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public EndpointSubsetBuilder(EndpointSubset instance) {
        this(instance, (Boolean)false);
    }

    public EndpointSubsetBuilder(EndpointSubset instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EndpointSubset build() {
        EndpointSubset buildable = new EndpointSubset(this.fluent.getAddresses(), this.fluent.getNotReadyAddresses(), this.fluent.getPorts());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetBuilder that = (EndpointSubsetBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

