/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_10;

import io.fabric8.kubernetes.api.model.v5_10.Service;
import io.fabric8.kubernetes.api.model.v5_10.ServicePort;
import io.fabric8.kubernetes.clnt.v5_10.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_10.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v5_10.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_10.utils.URLFromServiceUtil;
import io.fabric8.openshift.api.model.v5_10.Route;
import io.fabric8.openshift.clnt.v5_10.OpenShiftClient;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFromOpenshiftRouteImpl
implements ServiceToURLProvider {
    public static final Logger logger = LoggerFactory.getLogger(URLFromOpenshiftRouteImpl.class);

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        block4: {
            String serviceName = service.getMetadata().getName();
            ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
            if (port != null && port.getName() != null && client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                try {
                    String serviceProtocol = port.getProtocol();
                    OpenShiftClient openShiftClient = client.adapt(OpenShiftClient.class);
                    Route route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(service.getMetadata().getName())).get();
                    if (route != null) {
                        return (serviceProtocol + "://" + route.getSpec().getHost()).toLowerCase(Locale.ROOT);
                    }
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 403) break block4;
                    logger.warn("Could not lookup route:{} in namespace:{}, due to:{} ", new Object[]{serviceName, namespace, e.getMessage()});
                }
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FOURTH.getValue();
    }
}

