/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_10;

import io.fabric8.kubernetes.api.model.v5_10.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_10.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_10.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_10.RootPaths;
import io.fabric8.kubernetes.clnt.v5_10.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_10.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_10.Handlers;
import io.fabric8.kubernetes.clnt.v5_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_10.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_10.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_10.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.CreateOrDeleteable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_10.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Nameable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_10.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_10.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_10.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v5_10.utils.Serialization;
import io.fabric8.openshift.api.model.v5_10.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.v5_10.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.v5_10.Build;
import io.fabric8.openshift.api.model.v5_10.BuildConfig;
import io.fabric8.openshift.api.model.v5_10.BuildConfigList;
import io.fabric8.openshift.api.model.v5_10.BuildList;
import io.fabric8.openshift.api.model.v5_10.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_10.ClusterNetworkList;
import io.fabric8.openshift.api.model.v5_10.ClusterRole;
import io.fabric8.openshift.api.model.v5_10.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_10.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v5_10.ClusterRoleList;
import io.fabric8.openshift.api.model.v5_10.ClusterVersion;
import io.fabric8.openshift.api.model.v5_10.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_10.DeploymentConfigList;
import io.fabric8.openshift.api.model.v5_10.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v5_10.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v5_10.Group;
import io.fabric8.openshift.api.model.v5_10.GroupList;
import io.fabric8.openshift.api.model.v5_10.HelmChartRepository;
import io.fabric8.openshift.api.model.v5_10.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.v5_10.HostSubnet;
import io.fabric8.openshift.api.model.v5_10.HostSubnetList;
import io.fabric8.openshift.api.model.v5_10.Identity;
import io.fabric8.openshift.api.model.v5_10.IdentityList;
import io.fabric8.openshift.api.model.v5_10.Image;
import io.fabric8.openshift.api.model.v5_10.ImageList;
import io.fabric8.openshift.api.model.v5_10.ImageSignature;
import io.fabric8.openshift.api.model.v5_10.ImageStream;
import io.fabric8.openshift.api.model.v5_10.ImageStreamImage;
import io.fabric8.openshift.api.model.v5_10.ImageStreamImport;
import io.fabric8.openshift.api.model.v5_10.ImageStreamList;
import io.fabric8.openshift.api.model.v5_10.ImageStreamMapping;
import io.fabric8.openshift.api.model.v5_10.ImageStreamTag;
import io.fabric8.openshift.api.model.v5_10.ImageStreamTagList;
import io.fabric8.openshift.api.model.v5_10.ImageTag;
import io.fabric8.openshift.api.model.v5_10.ImageTagList;
import io.fabric8.openshift.api.model.v5_10.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v5_10.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v5_10.NetNamespace;
import io.fabric8.openshift.api.model.v5_10.NetNamespaceList;
import io.fabric8.openshift.api.model.v5_10.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_10.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_10.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_10.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v5_10.OAuthClient;
import io.fabric8.openshift.api.model.v5_10.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v5_10.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v5_10.OAuthClientList;
import io.fabric8.openshift.api.model.v5_10.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.v5_10.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.v5_10.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.v5_10.RangeAllocation;
import io.fabric8.openshift.api.model.v5_10.RangeAllocationList;
import io.fabric8.openshift.api.model.v5_10.ResourceAccessReview;
import io.fabric8.openshift.api.model.v5_10.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_10.Role;
import io.fabric8.openshift.api.model.v5_10.RoleBinding;
import io.fabric8.openshift.api.model.v5_10.RoleBindingList;
import io.fabric8.openshift.api.model.v5_10.RoleBindingRestriction;
import io.fabric8.openshift.api.model.v5_10.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.v5_10.RoleList;
import io.fabric8.openshift.api.model.v5_10.Route;
import io.fabric8.openshift.api.model.v5_10.RouteList;
import io.fabric8.openshift.api.model.v5_10.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_10.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v5_10.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v5_10.SubjectAccessReview;
import io.fabric8.openshift.api.model.v5_10.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_10.SubjectRulesReview;
import io.fabric8.openshift.api.model.v5_10.Template;
import io.fabric8.openshift.api.model.v5_10.TemplateInstance;
import io.fabric8.openshift.api.model.v5_10.TemplateInstanceList;
import io.fabric8.openshift.api.model.v5_10.TemplateList;
import io.fabric8.openshift.api.model.v5_10.User;
import io.fabric8.openshift.api.model.v5_10.UserIdentityMapping;
import io.fabric8.openshift.api.model.v5_10.UserList;
import io.fabric8.openshift.api.model.v5_10.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.v5_10.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.imageregistry.operator.v1.Config;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.clnt.v5_10.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftClusterAutoscalingAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_10.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_10.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_10.OpenShiftMachineAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftMachineConfigurationAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftStorageVersionMigratorApiGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftTunedAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftWhereaboutsAPIGroupClient;
import io.fabric8.openshift.clnt.v5_10.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_10.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_10.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_10.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_10.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_10.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v5_10.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v5_10.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.dsl.internal.user.UserOperationsImpl;
import io.fabric8.openshift.clnt.v5_10.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseKubernetesClient<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient {
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    private final URL openShiftUrl;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(io.fabric8.kubernetes.clnt.v5_10.Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        super(httpClient, config);
        try {
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfig getConfiguration() {
        return OpenShiftConfig.wrap(super.getConfiguration());
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return this.adapt(OpenShiftClusterAutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), item);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), s);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return OpenShiftHandlers.getOperation(CredentialsRequest.class, CredentialsRequestList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return OpenShiftHandlers.getOperation(HelmChartRepository.class, HelmChartRepositoryList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return OpenShiftHandlers.getOperation(Image.class, ImageList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return OpenShiftHandlers.getOperation(ImageTag.class, ImageTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return OpenShiftHandlers.getOperation(ImageStream.class, ImageStreamList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return OpenShiftHandlers.getOperation(ImageStreamTag.class, ImageStreamTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamImport.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamMapping.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        HasMetadataOperation<ImageStreamImage, ?, Resource<ImageStreamImage>> operation = Handlers.getNonListingOperation(ImageStreamImage.class, this.httpClient, this.getConfiguration());
        return operation::inNamespace;
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        final HasMetadataOperation<ImageSignature, ?, Resource<ImageSignature>> operation = Handlers.getNonListingOperation(ImageSignature.class, this.httpClient, this.getConfiguration());
        return new NameableCreateOrDeleteable(){

            @Override
            public Boolean delete() {
                return operation.delete();
            }

            @Override
            public ImageSignature create(ImageSignature item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public ImageSignature create(ImageSignature ... item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public CreateOrDeleteable<ImageSignature> withName(String name) {
                return operation.withName(name);
            }
        };
    }

    @Override
    public NonNamespaceOperation<Config, ConfigList, Resource<Config>> imageRegistryOperatorConfigs() {
        return OpenShiftHandlers.getOperation(Config.class, ConfigList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return new NetworkAttachmentDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicyReview.class, PodSecurityPolicyReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return OpenShiftHandlers.getOperation(OAuthClientAuthorization.class, OAuthClientAuthorizationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return OpenShiftHandlers.getOperation(OperatorPKI.class, OperatorPKIList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySelfSubjectReview.class, PodSecurityPolicySelfSubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySubjectReview.class, PodSecurityPolicySubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return OpenShiftHandlers.getOperation(RangeAllocation.class, RangeAllocationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return OpenShiftHandlers.getOperation(Route.class, RouteList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return OpenShiftHandlers.getOperation(TemplateInstance.class, TemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return this.adapt(OpenShiftTunedAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return OpenShiftHandlers.getOperation(BrokerTemplateInstance.class, BrokerTemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return OpenShiftHandlers.getOperation(RoleBindingRestriction.class, RoleBindingRestrictionList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        for (Supplier supplier : new Supplier[]{this::getOpenShiftV3Version, this::getOpenShiftV4VersionInfo}) {
            try {
                VersionInfo vi = (VersionInfo)supplier.get();
                if (vi == null) continue;
                return vi;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getVersion();
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return super.getVersion();
    }

    @Override
    public VersionInfo getOpenShiftV3Version() {
        return this.getVersionInfo(OPENSHIFT_VERSION_ENDPOINT);
    }

    private VersionInfo getOpenShiftV4VersionInfo() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(clusterVersion -> {
            String[] versionParts = clusterVersion.getStatus().getDesired().getVersion().split("\\.");
            VersionInfo.Builder versionInfoBuilder = new VersionInfo.Builder();
            if (versionParts.length > 2) {
                versionInfoBuilder.withMajor(versionParts[0]);
                versionInfoBuilder.withMinor(versionParts[1] + "." + versionParts[2]);
            }
            try {
                versionInfoBuilder.withBuildDate(clusterVersion.getMetadata().getCreationTimestamp());
            }
            catch (ParseException e) {
                return null;
            }
            return versionInfoBuilder.build();
        }).orElse(null);
    }

    @Override
    public String getOpenShiftV4Version() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(cv -> cv.getStatus().getDesired().getVersion()).orElse(null);
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return this.adapt(OpenShiftMachineConfigurationAPIGroupClient.class);
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return this.adapt(OpenShiftMachineAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return OpenShiftHandlers.getOperation(NetNamespace.class, NetNamespaceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return OpenShiftHandlers.getOperation(ClusterNetwork.class, ClusterNetworkList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return OpenShiftHandlers.getOperation(EgressNetworkPolicy.class, EgressNetworkPolicyList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return OpenShiftHandlers.getOperation(HostSubnet.class, HostSubnetList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return OpenShiftHandlers.getOperation(BareMetalHost.class, BareMetalHostList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(ResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalSubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SelfSubjectRulesReview.class, SelfSubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectRulesReview.class, SubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return this.adapt(OpenShiftStorageVersionMigratorApiGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return OpenShiftHandlers.getOperation(ClusterRole.class, ClusterRoleList.class, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return OpenShiftHandlers.getOperation(Identity.class, IdentityList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return Handlers.getNonListingOperation(UserIdentityMapping.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return OpenShiftHandlers.getOperation(UserOAuthAccessToken.class, UserOAuthAccessTokenList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return this.adapt(OpenShiftWhereaboutsAPIGroupClient.class);
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected OkHttpClient adaptOkHttpClient(OkHttpClient okHttpClient) {
        return OpenshiftAdapterSupport.adaptOkHttpClient(okHttpClient, this.getConfiguration());
    }
}

