/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_10.ComponentRouteSpec;
import io.fabric8.openshift.api.model.v5_10.ComponentRouteSpecFluent;
import io.fabric8.openshift.api.model.v5_10.ComponentRouteSpecFluentImpl;
import java.util.Objects;

public class ComponentRouteSpecBuilder
extends ComponentRouteSpecFluentImpl<ComponentRouteSpecBuilder>
implements VisitableBuilder<ComponentRouteSpec, ComponentRouteSpecBuilder> {
    ComponentRouteSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ComponentRouteSpecBuilder() {
        this(false);
    }

    public ComponentRouteSpecBuilder(Boolean validationEnabled) {
        this(new ComponentRouteSpec(), validationEnabled);
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ComponentRouteSpec(), validationEnabled);
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent, ComponentRouteSpec instance) {
        this(fluent, instance, false);
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpecFluent<?> fluent, ComponentRouteSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpec instance) {
        this(instance, (Boolean)false);
    }

    public ComponentRouteSpecBuilder(ComponentRouteSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withServingCertKeyPairSecret(instance.getServingCertKeyPairSecret());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ComponentRouteSpec build() {
        ComponentRouteSpec buildable = new ComponentRouteSpec(this.fluent.getHostname(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getServingCertKeyPairSecret());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentRouteSpecBuilder that = (ComponentRouteSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

