/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10.dsl.base;

import io.fabric8.kubernetes.api.model.v5_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_10.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_10.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v5_10.ObjectReference;
import io.fabric8.kubernetes.clnt.v5_10.dsl.FilterNested;
import io.fabric8.kubernetes.clnt.v5_10.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_10.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_10.utils.Utils;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class FilterNestedImpl<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
implements FilterNested<FilterWatchListDeletable<T, L>> {
    private static final String INVOLVED_OBJECT_NAME = "involvedObject.name";
    private static final String INVOLVED_OBJECT_NAMESPACE = "involvedObject.namespace";
    private static final String INVOLVED_OBJECT_KIND = "involvedObject.kind";
    private static final String INVOLVED_OBJECT_UID = "involvedObject.uid";
    private static final String INVOLVED_OBJECT_RESOURCE_VERSION = "involvedObject.resourceVersion";
    private static final String INVOLVED_OBJECT_API_VERSION = "involvedObject.apiVersion";
    private static final String INVOLVED_OBJECT_FIELD_PATH = "involvedObject.fieldPath";
    private final BaseOperation<T, L, R> baseOperation;
    private OperationContext context;

    FilterNestedImpl(BaseOperation<T, L, R> baseOperation) {
        this.baseOperation = baseOperation;
        this.context = this.baseOperation.context;
        this.context = this.context.copy();
        this.context.labels = new LinkedHashMap<String, String>(this.baseOperation.context.getLabels());
        this.context.labelsNot = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsNot());
        this.context.labelsIn = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsIn());
        this.context.labelsNotIn = new LinkedHashMap<String, String[]>(this.baseOperation.context.getLabelsNotIn());
        this.context.fields = new LinkedHashMap<String, String>(this.baseOperation.context.getFields());
        this.context.fieldsNot = new LinkedHashMap<String, String[]>(this.baseOperation.context.getFieldsNot());
        this.context.selectorAsString = this.baseOperation.context.selectorAsString;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabels(Map<String, String> labels) {
        this.context.labels.putAll(labels);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withoutLabels(Map<String, String> labels) {
        labels.forEach((string, string2) -> this.withoutLabel((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabelIn(String key, String ... values) {
        this.context.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabelNotIn(String key, String ... values) {
        this.context.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabel(String key, String value) {
        this.context.labels.put(key, value);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withoutLabel(String key, String value) {
        this.context.labelsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
            System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
            System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
            return concatList;
        });
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withFields(Map<String, String> fields) {
        this.context.fields.putAll(fields);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withField(String key, String value) {
        this.context.fields.put(key, value);
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withoutFields(Map<String, String> fields) {
        fields.forEach((string, string2) -> this.withoutField((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withoutField(String key, String value) {
        this.context.fieldsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            if (Utils.isNotNullOrEmpty(newList[0])) {
                String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
                System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
                System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
                return concatList;
            }
            return oldList;
        });
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabelSelector(LabelSelector selector) {
        List<LabelSelectorRequirement> matchExpressions;
        Map<String, String> matchLabels = selector.getMatchLabels();
        if (matchLabels != null) {
            this.withLabels((Map)matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block12: for (LabelSelectorRequirement req : matchExpressions) {
                String operator = req.getOperator();
                String key = req.getKey();
                switch (operator) {
                    case "In": {
                        this.withLabelIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "NotIn": {
                        this.withLabelNotIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "DoesNotExist": {
                        this.withoutLabel(key);
                        continue block12;
                    }
                    case "Exists": {
                        this.withLabel(key);
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unsupported operator: " + operator);
            }
        }
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference.getName() != null) {
            this.context.fields.put(INVOLVED_OBJECT_NAME, objectReference.getName());
        }
        if (objectReference.getNamespace() != null) {
            this.context.fields.put(INVOLVED_OBJECT_NAMESPACE, objectReference.getNamespace());
        }
        if (objectReference.getKind() != null) {
            this.context.fields.put(INVOLVED_OBJECT_KIND, objectReference.getKind());
        }
        if (objectReference.getUid() != null) {
            this.context.fields.put(INVOLVED_OBJECT_UID, objectReference.getUid());
        }
        if (objectReference.getResourceVersion() != null) {
            this.context.fields.put(INVOLVED_OBJECT_RESOURCE_VERSION, objectReference.getResourceVersion());
        }
        if (objectReference.getApiVersion() != null) {
            this.context.fields.put(INVOLVED_OBJECT_API_VERSION, objectReference.getApiVersion());
        }
        if (objectReference.getFieldPath() != null) {
            this.context.fields.put(INVOLVED_OBJECT_FIELD_PATH, objectReference.getFieldPath());
        }
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> and() {
        return this.baseOperation.newInstance(this.context);
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withLabelSelector(String selectorAsString) {
        this.context.selectorAsString = selectorAsString;
        return this;
    }
}

