/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.APIResourceList;
import io.fabric8.kubernetes.api.model.v5_10.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v5_10.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_10.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_10.BaseClient;
import io.fabric8.kubernetes.clnt.v5_10.Config;
import io.fabric8.kubernetes.clnt.v5_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_10.ResourceHandlerImpl;
import io.fabric8.kubernetes.clnt.v5_10.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v5_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_10.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_10.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_10.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v5_10.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_10.utils.Serialization;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import okhttp3.OkHttpClient;

public final class Handlers {
    private static final Map<Class<?>, ResourceHandler<?, ?>> RESOURCE_HANDLER_MAP = new ConcurrentHashMap();
    private static final Map<List<String>, ResourceDefinitionContext> GENERIC_RESOURCE_HANDLER_MAP = new ConcurrentHashMap<List<String>, ResourceDefinitionContext>();

    private Handlers() {
    }

    public static <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> void register(Class<T> type, BiFunction<OkHttpClient, Config, HasMetadataOperation<T, L, R>> operationConstructor) {
        if (RESOURCE_HANDLER_MAP.put(type, new ResourceHandlerImpl(type, operationConstructor)) != null) {
            throw new AssertionError((Object)String.format("%s already registered", type.getName()));
        }
    }

    public static <T extends HasMetadata> void unregister(Class<T> type) {
        RESOURCE_HANDLER_MAP.remove(type);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(T meta, BaseClient client) {
        ResourceDefinitionContext rdc;
        Class<?> type = meta.getClass();
        if (type.equals(GenericKubernetesResource.class) && (rdc = Handlers.getResourceDefinitionContext((GenericKubernetesResource)meta, client)) != null) {
            return new ResourceHandlerImpl(GenericKubernetesResource.class, GenericKubernetesResourceList.class, rdc);
        }
        return Handlers.get(type);
    }

    public static ResourceDefinitionContext getResourceDefinitionContext(String apiVersion, String kind, BaseClient client) {
        GenericKubernetesResource resource = new GenericKubernetesResource();
        resource.setKind(kind);
        resource.setApiVersion(apiVersion);
        return Handlers.getResourceDefinitionContext(resource, client);
    }

    public static <T extends HasMetadata> ResourceDefinitionContext getResourceDefinitionContext(GenericKubernetesResource meta, BaseClient client) {
        Object value = Serialization.unmarshal(Serialization.asJson(meta));
        Class<?> parsedType = value.getClass();
        ResourceDefinitionContext rdc = null;
        if (!parsedType.equals(GenericKubernetesResource.class)) {
            rdc = ResourceDefinitionContext.fromResourceType(parsedType);
        } else if (client != null) {
            String kind = meta.getKind();
            String apiVersion = meta.getApiVersion();
            if (kind == null || apiVersion == null) {
                return null;
            }
            String api = ApiVersionUtil.trimGroupOrNull(apiVersion);
            if (api == null) {
                return null;
            }
            String version = ApiVersionUtil.trimVersion(apiVersion);
            rdc = GENERIC_RESOURCE_HANDLER_MAP.computeIfAbsent(Arrays.asList(kind, apiVersion), k -> {
                APIResourceList resourceList = client.getApiResources(apiVersion);
                if (resourceList == null) {
                    return null;
                }
                return resourceList.getResources().stream().filter(r -> kind.equals(r.getKind())).findFirst().map(resource -> new ResourceDefinitionContext.Builder().withGroup(api).withKind(kind).withNamespaced(Boolean.TRUE.equals(resource.getNamespaced())).withPlural(resource.getName()).withVersion(version).build()).orElse(null);
            });
        }
        return rdc;
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(Class<T> type) {
        if (type.equals(GenericKubernetesResource.class)) {
            return null;
        }
        return RESOURCE_HANDLER_MAP.computeIfAbsent(type, k -> new ResourceHandlerImpl(type, null));
    }

    public static <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> HasMetadataOperation<T, L, R> getOperation(Class<T> type, Class<L> listType, OkHttpClient client, Config config) {
        ResourceHandler resourceHandler = Handlers.get(type);
        if (resourceHandler == null) {
            throw new IllegalStateException();
        }
        return resourceHandler.operation(client, config, listType);
    }

    public static <T extends HasMetadata> HasMetadataOperation<T, ?, Resource<T>> getNonListingOperation(Class<T> type, OkHttpClient client, Config config) {
        return Handlers.getOperation(type, KubernetesResourceUtil.inferListType(type), client, config);
    }

    public static <T extends HasMetadata> boolean shouldRegister(Class<T> type) {
        ResourceHandler<?, ?> handler = RESOURCE_HANDLER_MAP.get(type);
        return !RESOURCE_HANDLER_MAP.isEmpty() && (handler == null || !handler.hasOperation());
    }

    public static <T extends HasMetadata> NamespacedInOutCreateable<T, T> getNamespacedHasMetadataCreateOnlyOperation(Class<T> type, OkHttpClient client, Config config) {
        HasMetadataOperation<T, ?, Resource<T>> operation = Handlers.getNonListingOperation(type, client, config);
        return operation::inNamespace;
    }
}

