/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_10.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_10.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_10.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.v5_10.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.v5_10.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v5_10.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v5_10.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v5_10.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.v5_10.TypedLocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_10.TypedLocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimSpecFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private TypedLocalObjectReferenceBuilder dataSource;
    private TypedLocalObjectReferenceBuilder dataSourceRef;
    private ResourceRequirementsBuilder resources;
    private LabelSelectorBuilder selector;
    private String storageClassName;
    private String volumeMode;
    private String volumeName;
    private Map<String, Object> additionalProperties;

    public PersistentVolumeClaimSpecFluentImpl() {
    }

    public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withDataSource(instance.getDataSource());
        this.withDataSourceRef(instance.getDataSourceRef());
        this.withResources(instance.getResources());
        this.withSelector(instance.getSelector());
        this.withStorageClassName(instance.getStorageClassName());
        this.withVolumeMode(instance.getVolumeMode());
        this.withVolumeName(instance.getVolumeName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAccessModes(Integer index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(Integer index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(Integer index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    public A addNewAccessMode(String arg0) {
        return this.addToAccessModes(new String(arg0));
    }

    @Override
    @Deprecated
    public TypedLocalObjectReference getDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public TypedLocalObjectReference buildDataSource() {
        return this.dataSource != null ? this.dataSource.build() : null;
    }

    @Override
    public A withDataSource(TypedLocalObjectReference dataSource) {
        this._visitables.get("dataSource").remove(this.dataSource);
        if (dataSource != null) {
            this.dataSource = new TypedLocalObjectReferenceBuilder(dataSource);
            this._visitables.get("dataSource").add(this.dataSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDataSource() {
        return this.dataSource != null;
    }

    @Override
    public A withNewDataSource(String apiGroup, String kind, String name) {
        return this.withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
        return new DataSourceNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item) {
        return new DataSourceNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
        return this.withNewDataSourceLike(this.getDataSource());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : new TypedLocalObjectReferenceBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item) {
        return this.withNewDataSourceLike(this.getDataSource() != null ? this.getDataSource() : item);
    }

    @Override
    @Deprecated
    public TypedLocalObjectReference getDataSourceRef() {
        return this.dataSourceRef != null ? this.dataSourceRef.build() : null;
    }

    @Override
    public TypedLocalObjectReference buildDataSourceRef() {
        return this.dataSourceRef != null ? this.dataSourceRef.build() : null;
    }

    @Override
    public A withDataSourceRef(TypedLocalObjectReference dataSourceRef) {
        this._visitables.get("dataSourceRef").remove(this.dataSourceRef);
        if (dataSourceRef != null) {
            this.dataSourceRef = new TypedLocalObjectReferenceBuilder(dataSourceRef);
            this._visitables.get("dataSourceRef").add(this.dataSourceRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDataSourceRef() {
        return this.dataSourceRef != null;
    }

    @Override
    public A withNewDataSourceRef(String apiGroup, String kind, String name) {
        return this.withDataSourceRef(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRef() {
        return new DataSourceRefNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRefLike(TypedLocalObjectReference item) {
        return new DataSourceRefNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editDataSourceRef() {
        return this.withNewDataSourceRefLike(this.getDataSourceRef());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRef() {
        return this.withNewDataSourceRefLike(this.getDataSourceRef() != null ? this.getDataSourceRef() : new TypedLocalObjectReferenceBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRefLike(TypedLocalObjectReference item) {
        return this.withNewDataSourceRefLike(this.getDataSourceRef() != null ? this.getDataSourceRef() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @Override
    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    @Override
    @Deprecated
    public A withNewStorageClassName(String arg0) {
        return this.withStorageClassName(new String(arg0));
    }

    @Override
    public String getVolumeMode() {
        return this.volumeMode;
    }

    @Override
    public A withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeMode(String arg0) {
        return this.withVolumeMode(new String(arg0));
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeName(String arg0) {
        return this.withVolumeName(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) {
            return false;
        }
        if (this.dataSourceRef != null ? !this.dataSourceRef.equals(that.dataSourceRef) : that.dataSourceRef != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null) {
            return false;
        }
        if (this.volumeMode != null ? !this.volumeMode.equals(that.volumeMode) : that.volumeMode != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName, this.additionalProperties, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PersistentVolumeClaimSpecFluent.SelectorNested<N>>
    implements PersistentVolumeClaimSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements PersistentVolumeClaimSpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class DataSourceRefNestedImpl<N>
    extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>>
    implements PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>,
    Nested<N> {
        TypedLocalObjectReferenceBuilder builder;

        DataSourceRefNestedImpl(TypedLocalObjectReference item) {
            this.builder = new TypedLocalObjectReferenceBuilder(this, item);
        }

        DataSourceRefNestedImpl() {
            this.builder = new TypedLocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withDataSourceRef(this.builder.build());
        }

        @Override
        public N endDataSourceRef() {
            return this.and();
        }
    }

    public class DataSourceNestedImpl<N>
    extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceNested<N>>
    implements PersistentVolumeClaimSpecFluent.DataSourceNested<N>,
    Nested<N> {
        TypedLocalObjectReferenceBuilder builder;

        DataSourceNestedImpl(TypedLocalObjectReference item) {
            this.builder = new TypedLocalObjectReferenceBuilder(this, item);
        }

        DataSourceNestedImpl() {
            this.builder = new TypedLocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withDataSource(this.builder.build());
        }

        @Override
        public N endDataSource() {
            return this.and();
        }
    }
}

