/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.Handler;
import io.fabric8.kubernetes.api.model.v5_10.HandlerFluent;
import io.fabric8.kubernetes.api.model.v5_10.HandlerFluentImpl;
import java.util.Objects;

public class HandlerBuilder
extends HandlerFluentImpl<HandlerBuilder>
implements VisitableBuilder<Handler, HandlerBuilder> {
    HandlerFluent<?> fluent;
    Boolean validationEnabled;

    public HandlerBuilder() {
        this(false);
    }

    public HandlerBuilder(Boolean validationEnabled) {
        this(new Handler(), validationEnabled);
    }

    public HandlerBuilder(HandlerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Handler(), validationEnabled);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance) {
        this(fluent, instance, false);
    }

    public HandlerBuilder(HandlerFluent<?> fluent, Handler instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HandlerBuilder(Handler instance) {
        this(instance, (Boolean)false);
    }

    public HandlerBuilder(Handler instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withTcpSocket(instance.getTcpSocket());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Handler build() {
        Handler buildable = new Handler(this.fluent.getExec(), this.fluent.getHttpGet(), this.fluent.getTcpSocket());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HandlerBuilder that = (HandlerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

