/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.Config;
import io.fabric8.kubernetes.api.model.v5_10.ConfigFluent;
import io.fabric8.kubernetes.api.model.v5_10.ConfigFluentImpl;
import java.util.Objects;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder() {
        this(false);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClusters(instance.getClusters());
        fluent.withContexts(instance.getContexts());
        fluent.withCurrentContext(instance.getCurrentContext());
        fluent.withExtensions(instance.getExtensions());
        fluent.withKind(instance.getKind());
        fluent.withPreferences(instance.getPreferences());
        fluent.withUsers(instance.getUsers());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)false);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Config build() {
        Config buildable = new Config(this.fluent.getApiVersion(), this.fluent.getClusters(), this.fluent.getContexts(), this.fluent.getCurrentContext(), this.fluent.getExtensions(), this.fluent.getKind(), this.fluent.getPreferences(), this.fluent.getUsers());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

