/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.VLAN;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.VLANFluent;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.VLANFluentImpl;
import java.util.Objects;

public class VLANBuilder
extends VLANFluentImpl<VLANBuilder>
implements VisitableBuilder<VLAN, VLANBuilder> {
    VLANFluent<?> fluent;
    Boolean validationEnabled;

    public VLANBuilder() {
        this(false);
    }

    public VLANBuilder(Boolean validationEnabled) {
        this(new VLAN(), validationEnabled);
    }

    public VLANBuilder(VLANFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public VLANBuilder(VLANFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VLAN(), validationEnabled);
    }

    public VLANBuilder(VLANFluent<?> fluent, VLAN instance) {
        this(fluent, instance, false);
    }

    public VLANBuilder(VLANFluent<?> fluent, VLAN instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withId(instance.getId());
        fluent.withName(instance.getName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public VLANBuilder(VLAN instance) {
        this(instance, (Boolean)false);
    }

    public VLANBuilder(VLAN instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withId(instance.getId());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public VLAN build() {
        VLAN buildable = new VLAN(this.fluent.getId(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VLANBuilder that = (VLANBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

