/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.RootDeviceHints;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.RootDeviceHintsBuilder;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.RootDeviceHintsFluentImpl;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume;
import io.fabric8.openshift.api.model.v5_10.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SoftwareRAIDVolumeFluentImpl<A extends SoftwareRAIDVolumeFluent<A>>
extends BaseFluent<A>
implements SoftwareRAIDVolumeFluent<A> {
    private String level;
    private List<RootDeviceHintsBuilder> physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
    private Integer sizeGibibytes;
    private Map<String, Object> additionalProperties;

    public SoftwareRAIDVolumeFluentImpl() {
    }

    public SoftwareRAIDVolumeFluentImpl(SoftwareRAIDVolume instance) {
        this.withLevel(instance.getLevel());
        this.withPhysicalDisks(instance.getPhysicalDisks());
        this.withSizeGibibytes(instance.getSizeGibibytes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public A withLevel(String level) {
        this.level = level;
        return (A)this;
    }

    @Override
    public Boolean hasLevel() {
        return this.level != null;
    }

    @Override
    @Deprecated
    public A withNewLevel(String arg0) {
        return this.withLevel(new String(arg0));
    }

    @Override
    public A addToPhysicalDisks(Integer index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        this._visitables.get("physicalDisks").add(index >= 0 ? index.intValue() : this._visitables.get("physicalDisks").size(), builder);
        this.physicalDisks.add(index >= 0 ? index.intValue() : this.physicalDisks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPhysicalDisks(Integer index, RootDeviceHints item) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
        }
        RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
        if (index < 0 || index >= this._visitables.get("physicalDisks").size()) {
            this._visitables.get("physicalDisks").add(builder);
        } else {
            this._visitables.get("physicalDisks").set(index, builder);
        }
        if (index < 0 || index >= this.physicalDisks.size()) {
            this.physicalDisks.add(builder);
        } else {
            this.physicalDisks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPhysicalDisks(RootDeviceHints ... items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPhysicalDisks(Collection<RootDeviceHints> items) {
        if (this.physicalDisks == null) {
            this.physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
        }
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").add(builder);
            this.physicalDisks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPhysicalDisks(RootDeviceHints ... items) {
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").remove(builder);
            if (this.physicalDisks == null) continue;
            this.physicalDisks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPhysicalDisks(Collection<RootDeviceHints> items) {
        for (RootDeviceHints item : items) {
            RootDeviceHintsBuilder builder = new RootDeviceHintsBuilder(item);
            this._visitables.get("physicalDisks").remove(builder);
            if (this.physicalDisks == null) continue;
            this.physicalDisks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPhysicalDisks(Predicate<RootDeviceHintsBuilder> predicate) {
        if (this.physicalDisks == null) {
            return (A)this;
        }
        Iterator<RootDeviceHintsBuilder> each = this.physicalDisks.iterator();
        Object visitables = this._visitables.get("physicalDisks");
        while (each.hasNext()) {
            RootDeviceHintsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RootDeviceHints> getPhysicalDisks() {
        return SoftwareRAIDVolumeFluentImpl.build(this.physicalDisks);
    }

    @Override
    public List<RootDeviceHints> buildPhysicalDisks() {
        return SoftwareRAIDVolumeFluentImpl.build(this.physicalDisks);
    }

    @Override
    public RootDeviceHints buildPhysicalDisk(Integer index) {
        return this.physicalDisks.get(index).build();
    }

    @Override
    public RootDeviceHints buildFirstPhysicalDisk() {
        return this.physicalDisks.get(0).build();
    }

    @Override
    public RootDeviceHints buildLastPhysicalDisk() {
        return this.physicalDisks.get(this.physicalDisks.size() - 1).build();
    }

    @Override
    public RootDeviceHints buildMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        for (RootDeviceHintsBuilder item : this.physicalDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPhysicalDisks(List<RootDeviceHints> physicalDisks) {
        if (this.physicalDisks != null) {
            this._visitables.get("physicalDisks").removeAll(this.physicalDisks);
        }
        if (physicalDisks != null) {
            this.physicalDisks = new ArrayList<RootDeviceHintsBuilder>();
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        } else {
            this.physicalDisks = null;
        }
        return (A)this;
    }

    @Override
    public A withPhysicalDisks(RootDeviceHints ... physicalDisks) {
        if (this.physicalDisks != null) {
            this.physicalDisks.clear();
        }
        if (physicalDisks != null) {
            for (RootDeviceHints item : physicalDisks) {
                this.addToPhysicalDisks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPhysicalDisks() {
        return this.physicalDisks != null && !this.physicalDisks.isEmpty();
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> addNewPhysicalDisk() {
        return new PhysicalDisksNestedImpl();
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> addNewPhysicalDiskLike(RootDeviceHints item) {
        return new PhysicalDisksNestedImpl(-1, item);
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> setNewPhysicalDiskLike(Integer index, RootDeviceHints item) {
        return new PhysicalDisksNestedImpl(index, item);
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editPhysicalDisk(Integer index) {
        if (this.physicalDisks.size() <= index) {
            throw new RuntimeException("Can't edit physicalDisks. Index exceeds size.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editFirstPhysicalDisk() {
        if (this.physicalDisks.size() == 0) {
            throw new RuntimeException("Can't edit first physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(0, this.buildPhysicalDisk(0));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editLastPhysicalDisk() {
        int index = this.physicalDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last physicalDisks. The list is empty.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public SoftwareRAIDVolumeFluent.PhysicalDisksNested<A> editMatchingPhysicalDisk(Predicate<RootDeviceHintsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.physicalDisks.size(); ++i) {
            if (!predicate.test(this.physicalDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching physicalDisks. No match found.");
        }
        return this.setNewPhysicalDiskLike(index, this.buildPhysicalDisk(index));
    }

    @Override
    public Integer getSizeGibibytes() {
        return this.sizeGibibytes;
    }

    @Override
    public A withSizeGibibytes(Integer sizeGibibytes) {
        this.sizeGibibytes = sizeGibibytes;
        return (A)this;
    }

    @Override
    public Boolean hasSizeGibibytes() {
        return this.sizeGibibytes != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoftwareRAIDVolumeFluentImpl that = (SoftwareRAIDVolumeFluentImpl)o;
        if (this.level != null ? !this.level.equals(that.level) : that.level != null) {
            return false;
        }
        if (this.physicalDisks != null ? !this.physicalDisks.equals(that.physicalDisks) : that.physicalDisks != null) {
            return false;
        }
        if (this.sizeGibibytes != null ? !this.sizeGibibytes.equals(that.sizeGibibytes) : that.sizeGibibytes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.physicalDisks, this.sizeGibibytes, this.additionalProperties, super.hashCode());
    }

    public class PhysicalDisksNestedImpl<N>
    extends RootDeviceHintsFluentImpl<SoftwareRAIDVolumeFluent.PhysicalDisksNested<N>>
    implements SoftwareRAIDVolumeFluent.PhysicalDisksNested<N>,
    Nested<N> {
        RootDeviceHintsBuilder builder;
        Integer index;

        PhysicalDisksNestedImpl(Integer index, RootDeviceHints item) {
            this.index = index;
            this.builder = new RootDeviceHintsBuilder(this, item);
        }

        PhysicalDisksNestedImpl() {
            this.index = -1;
            this.builder = new RootDeviceHintsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SoftwareRAIDVolumeFluentImpl.this.setToPhysicalDisks(this.index, this.builder.build());
        }

        @Override
        public N endPhysicalDisk() {
            return this.and();
        }
    }
}

