/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_10.NetNamespace;
import io.fabric8.openshift.api.model.v5_10.NetNamespaceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetNamespaceFluentImpl<A extends NetNamespaceFluent<A>>
extends BaseFluent<A>
implements NetNamespaceFluent<A> {
    private String apiVersion;
    private List<String> egressIPs = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer netid;
    private String netname;
    private Map<String, Object> additionalProperties;

    public NetNamespaceFluentImpl() {
    }

    public NetNamespaceFluentImpl(NetNamespace instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withEgressIPs(instance.getEgressIPs());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withNetid(instance.getNetid());
        this.withNetname(instance.getNetname());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToEgressIPs(Integer index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEgressIPs(Integer index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgressIPs(String ... items) {
        for (String item : items) {
            if (this.egressIPs == null) continue;
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgressIPs(Collection<String> items) {
        for (String item : items) {
            if (this.egressIPs == null) continue;
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEgressIPs() {
        return this.egressIPs;
    }

    @Override
    public String getEgressIP(Integer index) {
        return this.egressIPs.get(index);
    }

    @Override
    public String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    @Override
    public String getLastEgressIP() {
        return this.egressIPs.get(this.egressIPs.size() - 1);
    }

    @Override
    public String getMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgressIPs(List<String> egressIPs) {
        if (egressIPs != null) {
            this.egressIPs = new ArrayList<String>();
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        } else {
            this.egressIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withEgressIPs(String ... egressIPs) {
        if (this.egressIPs != null) {
            this.egressIPs.clear();
        }
        if (egressIPs != null) {
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgressIPs() {
        return this.egressIPs != null && !this.egressIPs.isEmpty();
    }

    @Override
    public A addNewEgressIP(String arg0) {
        return this.addToEgressIPs(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NetNamespaceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NetNamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NetNamespaceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NetNamespaceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NetNamespaceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Integer getNetid() {
        return this.netid;
    }

    @Override
    public A withNetid(Integer netid) {
        this.netid = netid;
        return (A)this;
    }

    @Override
    public Boolean hasNetid() {
        return this.netid != null;
    }

    @Override
    public String getNetname() {
        return this.netname;
    }

    @Override
    public A withNetname(String netname) {
        this.netname = netname;
        return (A)this;
    }

    @Override
    public Boolean hasNetname() {
        return this.netname != null;
    }

    @Override
    @Deprecated
    public A withNewNetname(String arg0) {
        return this.withNetname(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetNamespaceFluentImpl that = (NetNamespaceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.egressIPs != null ? !this.egressIPs.equals(that.egressIPs) : that.egressIPs != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.netid != null ? !this.netid.equals(that.netid) : that.netid != null) {
            return false;
        }
        if (this.netname != null ? !this.netname.equals(that.netname) : that.netname != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.egressIPs, this.kind, this.metadata, this.netid, this.netname, this.additionalProperties, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NetNamespaceFluent.MetadataNested<N>>
    implements NetNamespaceFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetNamespaceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

