/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.openshift.api.model.v5_10.ImageLookupPolicy;
import io.fabric8.openshift.api.model.v5_10.ImageLookupPolicyBuilder;
import io.fabric8.openshift.api.model.v5_10.ImageLookupPolicyFluentImpl;
import io.fabric8.openshift.api.model.v5_10.ImageStreamSpec;
import io.fabric8.openshift.api.model.v5_10.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.v5_10.TagReference;
import io.fabric8.openshift.api.model.v5_10.TagReferenceBuilder;
import io.fabric8.openshift.api.model.v5_10.TagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamSpecFluentImpl<A extends ImageStreamSpecFluent<A>>
extends BaseFluent<A>
implements ImageStreamSpecFluent<A> {
    private String dockerImageRepository;
    private ImageLookupPolicyBuilder lookupPolicy;
    private List<TagReferenceBuilder> tags = new ArrayList<TagReferenceBuilder>();
    private Map<String, Object> additionalProperties;

    public ImageStreamSpecFluentImpl() {
    }

    public ImageStreamSpecFluentImpl(ImageStreamSpec instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withLookupPolicy(instance.getLookupPolicy());
        this.withTags(instance.getTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    @Override
    @Deprecated
    public A withNewDockerImageRepository(String arg0) {
        return this.withDockerImageRepository(new String(arg0));
    }

    @Override
    @Deprecated
    public ImageLookupPolicy getLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    @Override
    public ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    @Override
    public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this._visitables.get("lookupPolicy").remove(this.lookupPolicy);
        if (lookupPolicy != null) {
            this.lookupPolicy = new ImageLookupPolicyBuilder(lookupPolicy);
            this._visitables.get("lookupPolicy").add(this.lookupPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    @Override
    public A withNewLookupPolicy(Boolean local) {
        return this.withLookupPolicy(new ImageLookupPolicy(local));
    }

    @Override
    public ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicy() {
        return new LookupPolicyNestedImpl();
    }

    @Override
    public ImageStreamSpecFluent.LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
        return new LookupPolicyNestedImpl(item);
    }

    @Override
    public ImageStreamSpecFluent.LookupPolicyNested<A> editLookupPolicy() {
        return this.withNewLookupPolicyLike(this.getLookupPolicy());
    }

    @Override
    public ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicy() {
        return this.withNewLookupPolicyLike(this.getLookupPolicy() != null ? this.getLookupPolicy() : new ImageLookupPolicyBuilder().build());
    }

    @Override
    public ImageStreamSpecFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
        return this.withNewLookupPolicyLike(this.getLookupPolicy() != null ? this.getLookupPolicy() : item);
    }

    @Override
    public A addToTags(Integer index, TagReference item) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagReferenceBuilder>();
        }
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        this._visitables.get("tags").add(index >= 0 ? index.intValue() : this._visitables.get("tags").size(), builder);
        this.tags.add(index >= 0 ? index.intValue() : this.tags.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTags(Integer index, TagReference item) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagReferenceBuilder>();
        }
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("tags").size()) {
            this._visitables.get("tags").add(builder);
        } else {
            this._visitables.get("tags").set(index, builder);
        }
        if (index < 0 || index >= this.tags.size()) {
            this.tags.add(builder);
        } else {
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTags(TagReference ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagReferenceBuilder>();
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<TagReference> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagReferenceBuilder>();
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get("tags").add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(TagReference ... items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get("tags").remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<TagReference> items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get("tags").remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTags(Predicate<TagReferenceBuilder> predicate) {
        if (this.tags == null) {
            return (A)this;
        }
        Iterator<TagReferenceBuilder> each = this.tags.iterator();
        Object visitables = this._visitables.get("tags");
        while (each.hasNext()) {
            TagReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TagReference> getTags() {
        return ImageStreamSpecFluentImpl.build(this.tags);
    }

    @Override
    public List<TagReference> buildTags() {
        return ImageStreamSpecFluentImpl.build(this.tags);
    }

    @Override
    public TagReference buildTag(Integer index) {
        return this.tags.get(index).build();
    }

    @Override
    public TagReference buildFirstTag() {
        return this.tags.get(0).build();
    }

    @Override
    public TagReference buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    @Override
    public TagReference buildMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        for (TagReferenceBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        for (TagReferenceBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTags(List<TagReference> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").removeAll(this.tags);
        }
        if (tags != null) {
            this.tags = new ArrayList<TagReferenceBuilder>();
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    @Override
    public A withTags(TagReference ... tags) {
        if (this.tags != null) {
            this.tags.clear();
        }
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item) {
        return new TagsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> setNewTagLike(Integer index, TagReference item) {
        return new TagsNestedImpl(index, item);
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editTag(Integer index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        if (this.lookupPolicy != null ? !this.lookupPolicy.equals(that.lookupPolicy) : that.lookupPolicy != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.dockerImageRepository, this.lookupPolicy, this.tags, this.additionalProperties, super.hashCode());
    }

    public class TagsNestedImpl<N>
    extends TagReferenceFluentImpl<ImageStreamSpecFluent.TagsNested<N>>
    implements ImageStreamSpecFluent.TagsNested<N>,
    Nested<N> {
        TagReferenceBuilder builder;
        Integer index;

        TagsNestedImpl(Integer index, TagReference item) {
            this.index = index;
            this.builder = new TagReferenceBuilder(this, item);
        }

        TagsNestedImpl() {
            this.index = -1;
            this.builder = new TagReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamSpecFluentImpl.this.setToTags(this.index, this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }

    public class LookupPolicyNestedImpl<N>
    extends ImageLookupPolicyFluentImpl<ImageStreamSpecFluent.LookupPolicyNested<N>>
    implements ImageStreamSpecFluent.LookupPolicyNested<N>,
    Nested<N> {
        ImageLookupPolicyBuilder builder;

        LookupPolicyNestedImpl(ImageLookupPolicy item) {
            this.builder = new ImageLookupPolicyBuilder(this, item);
        }

        LookupPolicyNestedImpl() {
            this.builder = new ImageLookupPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamSpecFluentImpl.this.withLookupPolicy(this.builder.build());
        }

        @Override
        public N endLookupPolicy() {
            return this.and();
        }
    }
}

