/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_10.Group;
import io.fabric8.openshift.api.model.v5_10.GroupFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GroupFluentImpl<A extends GroupFluent<A>>
extends BaseFluent<A>
implements GroupFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> users = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public GroupFluentImpl() {
    }

    public GroupFluentImpl(Group instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withUsers(instance.getUsers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public GroupFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public GroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public GroupFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public GroupFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public GroupFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(Integer index, String item) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        if (this.users == null) {
            this.users = new ArrayList<String>();
        }
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            if (this.users == null) continue;
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(Integer index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsers(List<String> users) {
        if (users != null) {
            this.users = new ArrayList<String>();
            for (String item : users) {
                this.addToUsers(item);
            }
        } else {
            this.users = null;
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        if (this.users != null) {
            this.users.clear();
        }
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public A addNewUser(String arg0) {
        return this.addToUsers(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupFluentImpl that = (GroupFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.users, this.additionalProperties, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<GroupFluent.MetadataNested<N>>
    implements GroupFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)GroupFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

