/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.v5_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_10.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_10.ReplicationController;
import io.fabric8.kubernetes.clnt.v5_10.internal.serializationmixins.ObjectMetaMixIn;
import io.fabric8.kubernetes.clnt.v5_10.internal.serializationmixins.ReplicationControllerMixIn;

public class SerializationUtils {
    private static ObjectMapper mapper;
    private static ObjectMapper statelessMapper;

    private SerializationUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ObjectMapper getStatelessMapper() {
        if (statelessMapper == null) {
            statelessMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            statelessMapper.addMixInAnnotations(ObjectMeta.class, ObjectMetaMixIn.class);
            statelessMapper.addMixInAnnotations(ReplicationController.class, ReplicationControllerMixIn.class);
        }
        return statelessMapper;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        }
        return mapper;
    }

    public static String dumpAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getMapper().writeValueAsString((Object)obj);
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getStatelessMapper().writeValueAsString((Object)obj);
    }
}

