/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10.version;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_10.version.Info;
import io.fabric8.kubernetes.api.model.v5_10.version.InfoFluent;
import io.fabric8.kubernetes.api.model.v5_10.version.InfoFluentImpl;
import java.util.Objects;

public class InfoBuilder
extends InfoFluentImpl<InfoBuilder>
implements VisitableBuilder<Info, InfoBuilder> {
    InfoFluent<?> fluent;
    Boolean validationEnabled;

    public InfoBuilder() {
        this(false);
    }

    public InfoBuilder(Boolean validationEnabled) {
        this(new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public InfoBuilder(InfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Info(), validationEnabled);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance) {
        this(fluent, instance, false);
    }

    public InfoBuilder(InfoFluent<?> fluent, Info instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBuildDate(instance.getBuildDate());
        fluent.withCompiler(instance.getCompiler());
        fluent.withGitCommit(instance.getGitCommit());
        fluent.withGitTreeState(instance.getGitTreeState());
        fluent.withGitVersion(instance.getGitVersion());
        fluent.withGoVersion(instance.getGoVersion());
        fluent.withMajor(instance.getMajor());
        fluent.withMinor(instance.getMinor());
        fluent.withPlatform(instance.getPlatform());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public InfoBuilder(Info instance) {
        this(instance, (Boolean)false);
    }

    public InfoBuilder(Info instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBuildDate(instance.getBuildDate());
        this.withCompiler(instance.getCompiler());
        this.withGitCommit(instance.getGitCommit());
        this.withGitTreeState(instance.getGitTreeState());
        this.withGitVersion(instance.getGitVersion());
        this.withGoVersion(instance.getGoVersion());
        this.withMajor(instance.getMajor());
        this.withMinor(instance.getMinor());
        this.withPlatform(instance.getPlatform());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Info build() {
        Info buildable = new Info(this.fluent.getBuildDate(), this.fluent.getCompiler(), this.fluent.getGitCommit(), this.fluent.getGitTreeState(), this.fluent.getGitVersion(), this.fluent.getGoVersion(), this.fluent.getMajor(), this.fluent.getMinor(), this.fluent.getPlatform());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoBuilder that = (InfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

