/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_10.Nested;
import io.fabric8.kubernetes.api.model.v5_10.ScaleIOPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v5_10.ScaleIOPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v5_10.SecretReference;
import io.fabric8.kubernetes.api.model.v5_10.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_10.SecretReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ScaleIOPersistentVolumeSourceFluentImpl<A extends ScaleIOPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ScaleIOPersistentVolumeSourceFluent<A> {
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;
    private Map<String, Object> additionalProperties;

    public ScaleIOPersistentVolumeSourceFluentImpl() {
    }

    public ScaleIOPersistentVolumeSourceFluentImpl(ScaleIOPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withGateway(instance.getGateway());
        this.withProtectionDomain(instance.getProtectionDomain());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withSslEnabled(instance.getSslEnabled());
        this.withStorageMode(instance.getStorageMode());
        this.withStoragePool(instance.getStoragePool());
        this.withSystem(instance.getSystem());
        this.withVolumeName(instance.getVolumeName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public A withNewFsType(String arg0) {
        return this.withFsType(new String(arg0));
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)this;
    }

    @Override
    public Boolean hasGateway() {
        return this.gateway != null;
    }

    @Override
    @Deprecated
    public A withNewGateway(String arg0) {
        return this.withGateway(new String(arg0));
    }

    @Override
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)this;
    }

    @Override
    public Boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    @Override
    @Deprecated
    public A withNewProtectionDomain(String arg0) {
        return this.withProtectionDomain(new String(arg0));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public ScaleIOPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    @Override
    public String getStorageMode() {
        return this.storageMode;
    }

    @Override
    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)this;
    }

    @Override
    public Boolean hasStorageMode() {
        return this.storageMode != null;
    }

    @Override
    @Deprecated
    public A withNewStorageMode(String arg0) {
        return this.withStorageMode(new String(arg0));
    }

    @Override
    public String getStoragePool() {
        return this.storagePool;
    }

    @Override
    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)this;
    }

    @Override
    public Boolean hasStoragePool() {
        return this.storagePool != null;
    }

    @Override
    @Deprecated
    public A withNewStoragePool(String arg0) {
        return this.withStoragePool(new String(arg0));
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public A withSystem(String system) {
        this.system = system;
        return (A)this;
    }

    @Override
    public Boolean hasSystem() {
        return this.system != null;
    }

    @Override
    @Deprecated
    public A withNewSystem(String arg0) {
        return this.withSystem(new String(arg0));
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeName(String arg0) {
        return this.withVolumeName(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaleIOPersistentVolumeSourceFluentImpl that = (ScaleIOPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(that.gateway) : that.gateway != null) {
            return false;
        }
        if (this.protectionDomain != null ? !this.protectionDomain.equals(that.protectionDomain) : that.protectionDomain != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.sslEnabled != null ? !this.sslEnabled.equals(that.sslEnabled) : that.sslEnabled != null) {
            return false;
        }
        if (this.storageMode != null ? !this.storageMode.equals(that.storageMode) : that.storageMode != null) {
            return false;
        }
        if (this.storagePool != null ? !this.storagePool.equals(that.storagePool) : that.storagePool != null) {
            return false;
        }
        if (this.system != null ? !this.system.equals(that.system) : that.system != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, this.additionalProperties, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<ScaleIOPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements ScaleIOPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ScaleIOPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

