/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleBuilder;
import io.fabric8.openshift.api.model.PolicyRuleFluentImpl;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RoleFluentImpl<A extends RoleFluent<A>>
extends BaseFluent<A>
implements RoleFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<PolicyRuleBuilder> rules = new ArrayList<PolicyRuleBuilder>();

    public RoleFluentImpl() {
    }

    public RoleFluentImpl(Role instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRuleBuilder>();
        }
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRuleBuilder>();
        }
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRuleBuilder>();
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRuleBuilder>();
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(PolicyRule ... items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<PolicyRule> items) {
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<PolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<PolicyRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            PolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PolicyRule> getRules() {
        return RoleFluentImpl.build(this.rules);
    }

    @Override
    public List<PolicyRule> buildRules() {
        return RoleFluentImpl.build(this.rules);
    }

    @Override
    public PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public PolicyRule buildMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<PolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<PolicyRuleBuilder>();
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public RoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public RoleFluent.RulesNested<A> addNewRuleLike(PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public RoleFluent.RulesNested<A> setNewRuleLike(int index, PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public RoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public RoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public RoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public RoleFluent.RulesNested<A> editMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleFluentImpl that = (RoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.rules, super.hashCode());
    }

    public class RulesNestedImpl<N>
    extends PolicyRuleFluentImpl<RoleFluent.RulesNested<N>>
    implements RoleFluent.RulesNested<N>,
    Nested<N> {
        private final PolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, PolicyRule item) {
            this.index = index;
            this.builder = new PolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new PolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleFluent.MetadataNested<N>>
    implements RoleFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

