/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.OkHttpClient;

public class SharedInformerFactory
extends BaseOperation {
    private final Map<Type, SharedIndexInformer> informers = new HashMap<Type, SharedIndexInformer>();
    private final Map<Type, Future> startedInformers = new HashMap<Type, Future>();
    private final ExecutorService informerExecutor;
    private final BaseOperation baseOperation;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        super(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.initOperationContext(configuration);
        this.informerExecutor = threadPool;
        this.baseOperation = this.newInstance(this.context);
        this.namespace = null;
    }

    @Override
    public SharedInformerFactory inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public SharedInformerFactory withName(String name) {
        this.name = name;
        return this;
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), null, resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerForCustomResource(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, null, resyncPeriodInMillis);
    }

    private synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        ListerWatcher<T, L> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass);
        OperationContext context = this.context.withApiGroupName(HasMetadata.getGroup(apiTypeClass)).withApiGroupVersion(HasMetadata.getVersion(apiTypeClass)).withPlural(CustomResource.getPlural(apiTypeClass)).withIsNamespaceConfiguredFromGlobalConfig(this.context.isNamespaceFromGlobalConfig());
        if (this.namespace != null) {
            context = context.withNamespace(this.namespace).withIsNamespaceConfiguredFromGlobalConfig(false);
        }
        if (this.name != null) {
            context = context.withFields(Collections.singletonMap("metadata.name", this.name));
        }
        if (operationContext != null) {
            context = context.withOperationContext(operationContext);
            if (operationContext.getNamespace() != null) {
                context = context.withIsNamespaceConfiguredFromGlobalConfig(false);
            }
        }
        DefaultSharedIndexInformer<T, L> informer = new DefaultSharedIndexInformer<T, L>(apiTypeClass, listerWatcher, resyncPeriodInMillis, context, this.eventListeners);
        this.informers.put(apiTypeClass, informer);
        return informer;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> ListerWatcher<T, L> listerWatcherFor(final Class<T> apiTypeClass, final Class<L> apiListTypeClass) {
        return new ListerWatcher<T, L>(){

            @Override
            public L list(ListOptions params, String namespace, OperationContext context) {
                BaseOperation listBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        return this.informers.get(apiTypeClass);
    }

    public synchronized void startAllRegisteredInformers() {
        if (this.informers.isEmpty()) {
            return;
        }
        if (!this.informerExecutor.isShutdown()) {
            this.informers.forEach((informerType, informer) -> this.startedInformers.computeIfAbsent((Type)informerType, key -> this.informerExecutor.submit(informer::run)));
        }
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        if (this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.remove(informerType) != null) {
                informer.stop();
            }
        });
        if (shutDownThreadPool) {
            this.informerExecutor.shutdown();
        }
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> BaseOperation<T, L, ?> getConfiguredBaseOperation(String namespace, OperationContext context, Class<T> apiTypeClass, Class<L> apiListTypeClass) {
        BaseOperation baseOperationWithContext = context.isNamespaceFromGlobalConfig() ? this.baseOperation.newInstance(context.withConfig(((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build()).withNamespace(null)) : this.baseOperation.newInstance(context.withNamespace(namespace));
        baseOperationWithContext.setType(apiTypeClass);
        baseOperationWithContext.setListType(apiListTypeClass);
        return baseOperationWithContext;
    }

    private void initOperationContext(Config configuration) {
        if (configuration.getNamespace() != null) {
            this.context = this.context.withIsNamespaceConfiguredFromGlobalConfig(true);
        }
    }

    private <T extends HasMetadata> void registerKindToKubernetesDeserializer(Class<T> apiTypeClass) {
        if (CustomResource.class.isAssignableFrom(apiTypeClass)) {
            KubernetesDeserializer.registerCustomKind(HasMetadata.getApiVersion(apiTypeClass), apiTypeClass.getSimpleName(), apiTypeClass);
        }
    }
}

