/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_1.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.openshift.api.model.v5_1.ConfigMapFileReference;
import io.fabric8.openshift.api.model.v5_1.ConfigMapFileReferenceBuilder;
import io.fabric8.openshift.api.model.v5_1.ConfigMapFileReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_1.operator.v1.ConsoleCustomization;
import io.fabric8.openshift.api.model.v5_1.operator.v1.ConsoleCustomizationFluent;
import java.util.Objects;

public class ConsoleCustomizationFluentImpl<A extends ConsoleCustomizationFluent<A>>
extends BaseFluent<A>
implements ConsoleCustomizationFluent<A> {
    private String brand;
    private ConfigMapFileReferenceBuilder customLogoFile;
    private String customProductName;
    private String documentationBaseURL;

    public ConsoleCustomizationFluentImpl() {
    }

    public ConsoleCustomizationFluentImpl(ConsoleCustomization instance) {
        this.withBrand(instance.getBrand());
        this.withCustomLogoFile(instance.getCustomLogoFile());
        this.withCustomProductName(instance.getCustomProductName());
        this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
    }

    @Override
    public String getBrand() {
        return this.brand;
    }

    @Override
    public A withBrand(String brand) {
        this.brand = brand;
        return (A)this;
    }

    @Override
    public Boolean hasBrand() {
        return this.brand != null;
    }

    @Override
    public A withNewBrand(String arg1) {
        return this.withBrand(new String(arg1));
    }

    @Override
    public A withNewBrand(StringBuilder arg1) {
        return this.withBrand(new String(arg1));
    }

    @Override
    public A withNewBrand(StringBuffer arg1) {
        return this.withBrand(new String(arg1));
    }

    @Override
    @Deprecated
    public ConfigMapFileReference getCustomLogoFile() {
        return this.customLogoFile != null ? this.customLogoFile.build() : null;
    }

    @Override
    public ConfigMapFileReference buildCustomLogoFile() {
        return this.customLogoFile != null ? this.customLogoFile.build() : null;
    }

    @Override
    public A withCustomLogoFile(ConfigMapFileReference customLogoFile) {
        this._visitables.get("customLogoFile").remove(this.customLogoFile);
        if (customLogoFile != null) {
            this.customLogoFile = new ConfigMapFileReferenceBuilder(customLogoFile);
            this._visitables.get("customLogoFile").add(this.customLogoFile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCustomLogoFile() {
        return this.customLogoFile != null;
    }

    @Override
    public A withNewCustomLogoFile(String key, String name) {
        return this.withCustomLogoFile(new ConfigMapFileReference(key, name));
    }

    @Override
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFile() {
        return new CustomLogoFileNestedImpl();
    }

    @Override
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFileLike(ConfigMapFileReference item) {
        return new CustomLogoFileNestedImpl(item);
    }

    @Override
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editCustomLogoFile() {
        return this.withNewCustomLogoFileLike(this.getCustomLogoFile());
    }

    @Override
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFile() {
        return this.withNewCustomLogoFileLike(this.getCustomLogoFile() != null ? this.getCustomLogoFile() : new ConfigMapFileReferenceBuilder().build());
    }

    @Override
    public ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFileLike(ConfigMapFileReference item) {
        return this.withNewCustomLogoFileLike(this.getCustomLogoFile() != null ? this.getCustomLogoFile() : item);
    }

    @Override
    public String getCustomProductName() {
        return this.customProductName;
    }

    @Override
    public A withCustomProductName(String customProductName) {
        this.customProductName = customProductName;
        return (A)this;
    }

    @Override
    public Boolean hasCustomProductName() {
        return this.customProductName != null;
    }

    @Override
    public A withNewCustomProductName(String arg1) {
        return this.withCustomProductName(new String(arg1));
    }

    @Override
    public A withNewCustomProductName(StringBuilder arg1) {
        return this.withCustomProductName(new String(arg1));
    }

    @Override
    public A withNewCustomProductName(StringBuffer arg1) {
        return this.withCustomProductName(new String(arg1));
    }

    @Override
    public String getDocumentationBaseURL() {
        return this.documentationBaseURL;
    }

    @Override
    public A withDocumentationBaseURL(String documentationBaseURL) {
        this.documentationBaseURL = documentationBaseURL;
        return (A)this;
    }

    @Override
    public Boolean hasDocumentationBaseURL() {
        return this.documentationBaseURL != null;
    }

    @Override
    public A withNewDocumentationBaseURL(String arg1) {
        return this.withDocumentationBaseURL(new String(arg1));
    }

    @Override
    public A withNewDocumentationBaseURL(StringBuilder arg1) {
        return this.withDocumentationBaseURL(new String(arg1));
    }

    @Override
    public A withNewDocumentationBaseURL(StringBuffer arg1) {
        return this.withDocumentationBaseURL(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleCustomizationFluentImpl that = (ConsoleCustomizationFluentImpl)o;
        if (this.brand != null ? !this.brand.equals(that.brand) : that.brand != null) {
            return false;
        }
        if (this.customLogoFile != null ? !this.customLogoFile.equals(that.customLogoFile) : that.customLogoFile != null) {
            return false;
        }
        if (this.customProductName != null ? !this.customProductName.equals(that.customProductName) : that.customProductName != null) {
            return false;
        }
        return !(this.documentationBaseURL != null ? !this.documentationBaseURL.equals(that.documentationBaseURL) : that.documentationBaseURL != null);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.customLogoFile, this.customProductName, this.documentationBaseURL, super.hashCode());
    }

    public class CustomLogoFileNestedImpl<N>
    extends ConfigMapFileReferenceFluentImpl<ConsoleCustomizationFluent.CustomLogoFileNested<N>>
    implements ConsoleCustomizationFluent.CustomLogoFileNested<N>,
    Nested<N> {
        private final ConfigMapFileReferenceBuilder builder;

        CustomLogoFileNestedImpl(ConfigMapFileReference item) {
            this.builder = new ConfigMapFileReferenceBuilder(this, item);
        }

        CustomLogoFileNestedImpl() {
            this.builder = new ConfigMapFileReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleCustomizationFluentImpl.this.withCustomLogoFile(this.builder.build());
        }

        @Override
        public N endCustomLogoFile() {
            return this.and();
        }
    }
}

