/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_1.BuildConfigSpec;
import io.fabric8.openshift.api.model.v5_1.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.v5_1.BuildConfigSpecFluentImpl;
import java.util.Objects;

public class BuildConfigSpecBuilder
extends BuildConfigSpecFluentImpl<BuildConfigSpecBuilder>
implements VisitableBuilder<BuildConfigSpec, BuildConfigSpecBuilder> {
    BuildConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigSpecBuilder() {
        this(true);
    }

    public BuildConfigSpecBuilder(Boolean validationEnabled) {
        this(new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfigSpec(), validationEnabled);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance) {
        this(fluent, instance, true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withRunPolicy(instance.getRunPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        fluent.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withFailedBuildsHistoryLimit(instance.getFailedBuildsHistoryLimit());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withSuccessfulBuildsHistoryLimit(instance.getSuccessfulBuildsHistoryLimit());
        this.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildConfigSpec build() {
        BuildConfigSpec buildable = new BuildConfigSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getFailedBuildsHistoryLimit(), this.fluent.getNodeSelector(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getRunPolicy(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy(), this.fluent.getSuccessfulBuildsHistoryLimit(), this.fluent.getTriggers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecBuilder that = (BuildConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

