/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.informers.cache;

import io.fabric8.kubernetes.api.model.v5_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_1.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_1.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v5_1.informers.ResyncRunnable;
import io.fabric8.kubernetes.clnt.v5_1.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.clnt.v5_1.informers.cache.DeltaFIFO;
import io.fabric8.kubernetes.clnt.v5_1.informers.cache.Reflector;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private final long fullResyncPeriod;
    private final DeltaFIFO<T> queue;
    private final ListerWatcher<T, L> listerWatcher;
    private Reflector<T, L> reflector;
    private final Supplier<Boolean> resyncFunc;
    private final Consumer<Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>>> processFunc;
    private final ScheduledExecutorService reflectExecutor;
    private final ScheduledExecutorService resyncExecutor;
    private ScheduledFuture resyncFuture;
    private final OperationContext operationContext;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners;
    private final Class<T> apiTypeClass;

    public Controller(Class<T> apiTypeClass, DeltaFIFO<T> queue, ListerWatcher<T, L> listerWatcher, Consumer<Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>>> processFunc, Supplier<Boolean> resyncFunc, long fullResyncPeriod, OperationContext context, ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners) {
        this.queue = queue;
        this.listerWatcher = listerWatcher;
        this.apiTypeClass = apiTypeClass;
        this.processFunc = processFunc;
        this.resyncFunc = resyncFunc;
        if (fullResyncPeriod < 0L) {
            throw new IllegalArgumentException("Invalid resync period provided, It should be a non-negative value");
        }
        this.fullResyncPeriod = fullResyncPeriod;
        this.operationContext = context;
        this.eventListeners = eventListeners;
        this.reflectExecutor = Executors.newSingleThreadScheduledExecutor();
        this.resyncExecutor = Executors.newSingleThreadScheduledExecutor();
        this.initReflector();
    }

    public void run() {
        log.info("informer#Controller: ready to run resync and reflector runnable");
        if (this.fullResyncPeriod > 0L) {
            ResyncRunnable<Object> resyncRunnable = new ResyncRunnable<Object>(this.queue, this.resyncFunc);
            this.resyncFuture = this.resyncExecutor.scheduleAtFixedRate(resyncRunnable, this.fullResyncPeriod, this.fullResyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            log.info("informer#Controller: resync skipped due to 0 full resync period");
        }
        try {
            this.reflector.listAndWatch();
            this.processLoop();
        }
        catch (Exception exception) {
            log.warn("Reflector list-watching job exiting because the thread-pool is shutting down", (Throwable)exception);
            this.eventListeners.forEach(listener -> listener.onException(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Controller controller = this;
        synchronized (controller) {
            this.reflector.stop();
            this.reflectExecutor.shutdown();
        }
    }

    public boolean hasSynced() {
        return this.queue.hasSynced();
    }

    public String lastSyncResourceVersion() {
        if (this.reflector == null) {
            return "";
        }
        return this.reflector.getLastSyncResourceVersion();
    }

    Reflector<T, L> getReflector() {
        return this.reflector;
    }

    private void processLoop() throws Exception {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.queue.pop(this.processFunc);
            }
            catch (InterruptedException t) {
                log.warn("DefaultController#processLoop got interrupted {}", (Object)t.getMessage(), (Object)t);
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                log.error("DefaultController#processLoop recovered from crashing {} ", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
    }

    private void initReflector() {
        this.reflector = new Reflector<T, L>(this.apiTypeClass, this.listerWatcher, this.queue, this.operationContext, this.fullResyncPeriod);
    }
}

