/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v5_1.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v5_1.PodList;
import io.fabric8.kubernetes.api.model.v5_1.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Operation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import okhttp3.OkHttpClient;

class StatefulSetRollingUpdater
extends RollingUpdater<StatefulSet, StatefulSetList> {
    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected StatefulSet createClone(StatefulSet obj, String newName, String newDeploymentHash) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)((StatefulSetFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(StatefulSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected StatefulSet updateDeploymentKey(String name, String hash) {
        StatefulSet old = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        StatefulSet updated = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetBuilder(old).editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected StatefulSet removeDeploymentKey(String name) {
        StatefulSet old = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        StatefulSet updated = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetBuilder(old).editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected int getReplicas(StatefulSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected StatefulSet setReplicas(StatefulSet obj, int replicas) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)new StatefulSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>> resources() {
        return new StatefulSetOperationsImpl(this.client, this.config);
    }
}

