/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.DeleteOptions;
import io.fabric8.kubernetes.api.model.v5_1.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.v5_1.Preconditions;
import io.fabric8.kubernetes.api.model.v5_1.PreconditionsBuilder;
import io.fabric8.kubernetes.api.model.v5_1.PreconditionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>>
extends BaseFluent<A>
implements DeleteOptionsFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private PreconditionsBuilder preconditions;
    private String propagationPolicy;

    public DeleteOptionsFluentImpl() {
    }

    public DeleteOptionsFluentImpl(DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDryRun(instance.getDryRun());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.getOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
        this.withPropagationPolicy(instance.getPropagationPolicy());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDryRun(String ... items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDryRun(Collection<String> items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDryRun() {
        return this.dryRun;
    }

    @Override
    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    @Override
    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    @Override
    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    @Override
    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDryRun(List<String> dryRun) {
        if (this.dryRun != null) {
            this._visitables.get("dryRun").removeAll(this.dryRun);
        }
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    @Override
    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    @Override
    public A addNewDryRun(String arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public A addNewDryRun(StringBuilder arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public A addNewDryRun(StringBuffer arg1) {
        return this.addToDryRun(new String(arg1));
    }

    @Override
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Override
    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    @Override
    public A withNewGracePeriodSeconds(String arg1) {
        return this.withGracePeriodSeconds(new Long(arg1));
    }

    @Override
    public A withNewGracePeriodSeconds(long arg1) {
        return this.withGracePeriodSeconds(new Long(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public Boolean isOrphanDependents() {
        return this.orphanDependents;
    }

    @Override
    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    @Override
    public A withNewOrphanDependents(String arg1) {
        return this.withOrphanDependents(new Boolean(arg1));
    }

    @Override
    public A withNewOrphanDependents(boolean arg1) {
        return this.withOrphanDependents(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public Preconditions getPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    @Override
    public A withPreconditions(Preconditions preconditions) {
        this._visitables.get("preconditions").remove(this.preconditions);
        if (preconditions != null) {
            this.preconditions = new PreconditionsBuilder(preconditions);
            this._visitables.get("preconditions").add(this.preconditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    @Override
    public A withNewPreconditions(String resourceVersion, String uid) {
        return this.withPreconditions(new Preconditions(resourceVersion, uid));
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNestedImpl();
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item) {
        return new PreconditionsNestedImpl(item);
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : new PreconditionsBuilder().build());
    }

    @Override
    public DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(Preconditions item) {
        return this.withNewPreconditionsLike(this.getPreconditions() != null ? this.getPreconditions() : item);
    }

    @Override
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    @Override
    public A withNewPropagationPolicy(String arg1) {
        return this.withPropagationPolicy(new String(arg1));
    }

    @Override
    public A withNewPropagationPolicy(StringBuilder arg1) {
        return this.withPropagationPolicy(new String(arg1));
    }

    @Override
    public A withNewPropagationPolicy(StringBuffer arg1) {
        return this.withPropagationPolicy(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) {
            return false;
        }
        if (this.gracePeriodSeconds != null ? !this.gracePeriodSeconds.equals(that.gracePeriodSeconds) : that.gracePeriodSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.orphanDependents != null ? !this.orphanDependents.equals(that.orphanDependents) : that.orphanDependents != null) {
            return false;
        }
        if (this.preconditions != null ? !this.preconditions.equals(that.preconditions) : that.preconditions != null) {
            return false;
        }
        return !(this.propagationPolicy != null ? !this.propagationPolicy.equals(that.propagationPolicy) : that.propagationPolicy != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy, super.hashCode());
    }

    public class PreconditionsNestedImpl<N>
    extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>>
    implements DeleteOptionsFluent.PreconditionsNested<N>,
    Nested<N> {
        private final PreconditionsBuilder builder;

        PreconditionsNestedImpl(Preconditions item) {
            this.builder = new PreconditionsBuilder(this, item);
        }

        PreconditionsNestedImpl() {
            this.builder = new PreconditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeleteOptionsFluentImpl.this.withPreconditions(this.builder.build());
        }

        @Override
        public N endPreconditions() {
            return this.and();
        }
    }
}

