/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.internal.readiness.OpenShiftReadiness;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
extends NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl {
    public OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Map<String, String> parameters, Boolean cascading, DeletionPropagation propagationPolicy) {
        super(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, is, parameters, cascading, propagationPolicy);
    }

    public OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, Map<String, String> parameters, DeletionPropagation propagationPolicy, Boolean cascading) {
        super(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, item, parameters, propagationPolicy, cascading);
    }

    public OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, InputStream inputStream, Map<String, String> parameters, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier) {
        super(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, item, inputStream, parameters, gracePeriodSeconds, propagationPolicy, cascading, watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier);
    }

    @Override
    protected OpenShiftReadiness getReadiness() {
        return OpenShiftReadiness.getInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> List<HasMetadata> asHasMetadata(T item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
            return result;
        }
        if (item instanceof Template) {
            result.addAll(OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.processTemplateList((Template)item, enableProccessing));
            return result;
        }
        if (item instanceof KubernetesResourceList) {
            result.addAll(((KubernetesResourceList)item).getItems());
            return result;
        }
        if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
            return result;
        }
        if (item instanceof String) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
                List<HasMetadata> list = this.asHasMetadata(OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.unmarshal(is), enableProccessing);
                return list;
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        if (!(item instanceof Collection)) return result;
        Iterator iterator = ((Collection)item).iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof HasMetadata)) continue;
            result.add((HasMetadata)o);
        }
        return result;
    }

    private static List<HasMetadata> processTemplate(Template template, Boolean failOnMissing) {
        List<Parameter> parameters = template != null ? template.getParameters() : null;
        List<HasMetadata> objects = template != null ? template.getObjects() : Collections.emptyList();
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(objects)).build();
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (Utils.isNotNullOrEmpty(parameter.getValue())) {
                            value = parameter.getValue();
                        } else if ("expression".equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            if (Boolean.TRUE.equals(failOnMissing)) {
                                throw new IllegalArgumentException("No value available for parameter name: " + name);
                            }
                            value = "";
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)OBJECT_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return list.getItems();
    }

    private static List<HasMetadata> processTemplateList(Template item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (Boolean.FALSE.equals(enableProccessing)) {
            result.addAll(item.getObjects());
        } else {
            result.addAll(OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.processTemplate(item, false));
        }
        return result;
    }
}

