/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_1;

import io.fabric8.kubernetes.clnt.v5_1.BaseClient;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import io.fabric8.openshift.api.model.v5_1.APIServer;
import io.fabric8.openshift.api.model.v5_1.APIServerList;
import io.fabric8.openshift.api.model.v5_1.ClusterOperator;
import io.fabric8.openshift.api.model.v5_1.ClusterOperatorList;
import io.fabric8.openshift.api.model.v5_1.ClusterVersion;
import io.fabric8.openshift.api.model.v5_1.ClusterVersionList;
import io.fabric8.openshift.api.model.v5_1.FeatureGate;
import io.fabric8.openshift.api.model.v5_1.FeatureGateList;
import io.fabric8.openshift.api.model.v5_1.Infrastructure;
import io.fabric8.openshift.api.model.v5_1.InfrastructureList;
import io.fabric8.openshift.api.model.v5_1.OAuth;
import io.fabric8.openshift.api.model.v5_1.OAuthList;
import io.fabric8.openshift.api.model.v5_1.OperatorHub;
import io.fabric8.openshift.api.model.v5_1.OperatorHubList;
import io.fabric8.openshift.api.model.v5_1.Proxy;
import io.fabric8.openshift.api.model.v5_1.ProxyList;
import io.fabric8.openshift.api.model.v5_1.Scheduler;
import io.fabric8.openshift.api.model.v5_1.SchedulerList;
import io.fabric8.openshift.clnt.v5_1.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_1.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.APIServerOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.ClusterOperatorOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.ClusterVersionOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.FeatureGateOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.InfrastructureOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.OAuthOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.OperatorHubOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.ProxyOperationsImpl;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.SchedulerOperationsImpl;
import okhttp3.OkHttpClient;

public class OpenShiftConfigAPIGroupClient
extends BaseClient
implements OpenShiftConfigAPIGroupDSL {
    public OpenShiftConfigAPIGroupClient() {
    }

    public OpenShiftConfigAPIGroupClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<APIServer, APIServerList, Resource<APIServer>> apiServers() {
        return new APIServerOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterOperator, ClusterOperatorList, Resource<ClusterOperator>> clusterOperators() {
        return new ClusterOperatorOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterVersion, ClusterVersionList, Resource<ClusterVersion>> clusterVersions() {
        return new ClusterVersionOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<FeatureGate, FeatureGateList, Resource<FeatureGate>> featureGates() {
        return new FeatureGateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Infrastructure, InfrastructureList, Resource<Infrastructure>> infrastructures() {
        return new InfrastructureOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuth, OAuthList, Resource<OAuth>> oAuths() {
        return new OAuthOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OperatorHub, OperatorHubList, Resource<OperatorHub>> operatorHubs() {
        return new OperatorHubOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Proxy, ProxyList, Resource<Proxy>> proxies() {
        return new ProxyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Scheduler, SchedulerList, Resource<Scheduler>> schedulers() {
        return new SchedulerOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }
}

