/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_1.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_1.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.v5_1.OAuthAccessTokenFluentImpl;
import java.util.Objects;

public class OAuthAccessTokenBuilder
extends OAuthAccessTokenFluentImpl<OAuthAccessTokenBuilder>
implements VisitableBuilder<OAuthAccessToken, OAuthAccessTokenBuilder> {
    OAuthAccessTokenFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthAccessTokenBuilder() {
        this(true);
    }

    public OAuthAccessTokenBuilder(Boolean validationEnabled) {
        this(new OAuthAccessToken(), validationEnabled);
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthAccessToken(), validationEnabled);
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent, OAuthAccessToken instance) {
        this(fluent, instance, true);
    }

    public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent, OAuthAccessToken instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withAuthorizeToken(instance.getAuthorizeToken());
        fluent.withClientName(instance.getClientName());
        fluent.withExpiresIn(instance.getExpiresIn());
        fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURI(instance.getRedirectURI());
        fluent.withRefreshToken(instance.getRefreshToken());
        fluent.withScopes(instance.getScopes());
        fluent.withUserName(instance.getUserName());
        fluent.withUserUID(instance.getUserUID());
        this.validationEnabled = validationEnabled;
    }

    public OAuthAccessTokenBuilder(OAuthAccessToken instance) {
        this(instance, (Boolean)true);
    }

    public OAuthAccessTokenBuilder(OAuthAccessToken instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withAuthorizeToken(instance.getAuthorizeToken());
        this.withClientName(instance.getClientName());
        this.withExpiresIn(instance.getExpiresIn());
        this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURI(instance.getRedirectURI());
        this.withRefreshToken(instance.getRefreshToken());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public OAuthAccessToken build() {
        OAuthAccessToken buildable = new OAuthAccessToken(this.fluent.getApiVersion(), this.fluent.getAuthorizeToken(), this.fluent.getClientName(), this.fluent.getExpiresIn(), this.fluent.getInactivityTimeoutSeconds(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURI(), this.fluent.getRefreshToken(), this.fluent.getScopes(), this.fluent.getUserName(), this.fluent.getUserUID());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAccessTokenBuilder that = (OAuthAccessTokenBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

