/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_1.server.mock.KubernetesCrudAttributesExtractor;
import io.fabric8.kubernetes.clnt.v5_1.server.mock.KubernetesResponseComposer;
import io.fabric8.kubernetes.clnt.v5_1.server.mock.WatchEventsListener;
import io.fabric8.kubernetes.clnt.v5_1.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.CrudDispatcher;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import io.fabric8.zjsonpatch.JsonPatch;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCrudDispatcher
extends CrudDispatcher {
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String PATCH = "PATCH";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesCrudDispatcher.class);
    private final Set<WatchEventsListener> watchEventListeners = new CopyOnWriteArraySet<WatchEventsListener>();

    public KubernetesCrudDispatcher() {
        this(Collections.emptyList());
    }

    public KubernetesCrudDispatcher(List<CustomResourceDefinitionContext> crdContexts) {
        this(new KubernetesCrudAttributesExtractor(crdContexts), new KubernetesResponseComposer());
    }

    public KubernetesCrudDispatcher(KubernetesCrudAttributesExtractor attributeExtractor, ResponseComposer responseComposer) {
        super(new Context(Serialization.jsonMapper()), (AttributeExtractor)attributeExtractor, responseComposer);
    }

    public synchronized MockResponse dispatch(RecordedRequest request) {
        String path = request.getPath();
        String method = request.getMethod();
        switch (method.toUpperCase()) {
            case "POST": {
                return this.handleCreate(path, request.getBody().readUtf8());
            }
            case "PUT": {
                return this.handleReplace(path, request.getBody().readUtf8());
            }
            case "PATCH": {
                return this.handlePatch(path, request.getBody().readUtf8());
            }
            case "GET": {
                return this.detectWatchMode(path) ? this.handleWatch(path) : this.handleGet(path);
            }
            case "DELETE": {
                return this.handleDelete(path);
            }
        }
        return null;
    }

    public MockResponse handleCreate(String path, String s) {
        return new MockResponse().setResponseCode(this.doCreate(path, s, "ADDED")).setBody(s);
    }

    public MockResponse handleReplace(String path, String s) {
        if (this.doDelete(path, null) == 404) {
            return new MockResponse().setResponseCode(404);
        }
        return new MockResponse().setResponseCode(this.doCreate(path, s, "MODIFIED")).setBody(s);
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> {
            LOGGER.debug("Entry found for query {} : {}", (Object)query, entry);
            items.add(entry.getValue());
        });
        if (query.containsKey("name")) {
            if (!items.isEmpty()) {
                response.setBody((String)items.get(0));
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        } else {
            response.setBody(this.responseComposer.compose(items));
            response.setResponseCode(200);
        }
        return response;
    }

    public MockResponse handlePatch(String path, String s) {
        MockResponse response = new MockResponse();
        String body = this.fetchResource(path);
        if (body == null) {
            response.setResponseCode(404);
        } else {
            try {
                JsonNode patch = this.context.getMapper().readTree(s);
                JsonNode source = this.context.getMapper().readTree(body);
                JsonNode updated = JsonPatch.apply((JsonNode)patch, (JsonNode)source);
                String updatedAsString = this.context.getMapper().writeValueAsString((Object)updated);
                AttributeSet query = this.attributeExtractor.fromPath(path);
                AttributeSet attributeSet = (AttributeSet)this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).findFirst().orElseThrow(IllegalStateException::new).getKey();
                this.map.remove(attributeSet);
                AttributeSet newAttributeSet = AttributeSet.merge((AttributeSet[])new AttributeSet[]{attributeSet, this.attributeExtractor.fromResource(updatedAsString)});
                this.map.put(newAttributeSet, updatedAsString);
                AtomicBoolean flag = new AtomicBoolean(false);
                AttributeSet finalAttributeSet = attributeSet;
                this.watchEventListeners.stream().filter(watchEventsListener -> watchEventsListener.attributeMatches(finalAttributeSet)).forEach(watchEventsListener -> {
                    flag.set(true);
                    watchEventsListener.sendWebSocketResponse(updatedAsString, "MODIFIED");
                });
                if (!flag.get()) {
                    this.watchEventListeners.stream().filter(watchEventsListener -> watchEventsListener.attributeMatches(newAttributeSet)).forEach(watchEventsListener -> watchEventsListener.sendWebSocketResponse(updatedAsString, "ADDED"));
                }
                response.setResponseCode(202);
                response.setBody(updatedAsString);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return response;
    }

    public MockResponse handleDelete(String path) {
        return new MockResponse().setResponseCode(this.doDelete(path, "DELETED"));
    }

    public MockResponse handleWatch(String path) {
        MockResponse mockResponse = new MockResponse();
        String resourceName = this.fetchResourceNameFromWatchRequestPath(path);
        AttributeSet query = this.attributeExtractor.fromPath(path);
        if (resourceName != null) {
            query = query.add(new Attribute[]{new Attribute("name", resourceName)});
        }
        WatchEventsListener watchEventListener = new WatchEventsListener(this.context, query, this.watchEventListeners, LOGGER);
        this.watchEventListeners.add(watchEventListener);
        mockResponse.setSocketPolicy(SocketPolicy.KEEP_OPEN);
        return mockResponse.withWebSocketUpgrade((WebSocketListener)watchEventListener);
    }

    private boolean detectWatchMode(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("incorrect URI string: [{}]", (Object)path);
            return false;
        }
        if (queryString != null && !queryString.isEmpty()) {
            return queryString.contains("watch=true");
        }
        return false;
    }

    private String fetchResourceNameFromWatchRequestPath(String path) {
        String queryString = null;
        try {
            queryString = new URI(path).getQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.debug("Incorrect URI string: [{}]", (Object)path);
            return null;
        }
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        String name = "";
        for (String q : queryString.split("&")) {
            if (!q.contains("fieldSelector") || !q.contains("metadata.name")) continue;
            String[] s = q.split("=");
            name = s[s.length - 1];
        }
        return name.isEmpty() ? null : name;
    }

    private String fetchResource(String path) {
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> items.add(entry.getValue()));
        if (items.isEmpty()) {
            return null;
        }
        if (items.size() == 1) {
            return (String)items.get(0);
        }
        return this.responseComposer.compose(items);
    }

    private int doDelete(String path, String event) {
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.fromPath(path);
        this.map.entrySet().stream().filter(entry -> ((AttributeSet)entry.getKey()).matches(query)).forEach(entry -> items.add(entry.getKey()));
        if (items.isEmpty()) {
            return 404;
        }
        items.forEach(item -> {
            if (event != null && !event.isEmpty()) {
                this.watchEventListeners.stream().filter(listener -> listener.attributeMatches((AttributeSet)item)).forEach(listener -> listener.sendWebSocketResponse((String)this.map.get(item), event));
            }
            this.map.remove(item);
        });
        return 200;
    }

    private int doCreate(String path, String s, String event) {
        AttributeSet features = AttributeSet.merge((AttributeSet[])new AttributeSet[]{this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(s)});
        this.map.put(features, s);
        if (event != null && !event.isEmpty()) {
            this.watchEventListeners.stream().filter(listener -> listener.attributeMatches(features)).forEach(listener -> listener.sendWebSocketResponse(s, event));
        }
        return 200;
    }
}

