/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.ListOptions;
import io.fabric8.kubernetes.api.model.v5_1.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_1.ServiceAccountBuilder;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_1.Watch;
import io.fabric8.kubernetes.clnt.v5_1.Watcher;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ServiceAccountOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceAccountHandler
implements ResourceHandler<ServiceAccount, ServiceAccountBuilder> {
    @Override
    public String getKind() {
        return ServiceAccount.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public ServiceAccount create(OkHttpClient client, Config config, String namespace, ServiceAccount item) {
        return (ServiceAccount)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ServiceAccount[0]);
    }

    @Override
    public ServiceAccount replace(OkHttpClient client, Config config, String namespace, ServiceAccount item) {
        return ((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ServiceAccount reload(OkHttpClient client, Config config, String namespace, ServiceAccount item) {
        return (ServiceAccount)((Gettable)((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ServiceAccountBuilder edit(ServiceAccount item) {
        return new ServiceAccountBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceAccount item) {
        return new ServiceAccountOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, Watcher<ServiceAccount> watcher) {
        return ((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, String resourceVersion, Watcher<ServiceAccount> watcher) {
        return ((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceAccount item, ListOptions options, Watcher<ServiceAccount> watcher) {
        return ((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ServiceAccount waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceAccount item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceAccount)((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ServiceAccount waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceAccount item, Predicate<ServiceAccount> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceAccount)((Resource)new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

