/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.extended.run;

import io.fabric8.kubernetes.api.model.v5_1.Pod;
import io.fabric8.kubernetes.api.model.v5_1.PodBuilder;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.EditableRunConfig;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.RunConfig;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.RunConfigUtil;
import okhttp3.OkHttpClient;

public class RunOperations {
    private final OkHttpClient client;
    private final Config config;
    private final String namespace;
    private final RunConfigBuilder runConfigBuilder;

    public RunOperations(OkHttpClient client, Config config, String namespace, RunConfigBuilder runConfigBuilder) {
        this.client = client;
        this.config = config;
        this.namespace = namespace;
        this.runConfigBuilder = runConfigBuilder;
    }

    public RunOperations inNamespace(String namespace) {
        return new RunOperations(this.client, this.config, namespace, this.runConfigBuilder);
    }

    public RunOperations withImage(String image) {
        return new RunOperations(this.client, this.config, this.namespace, (RunConfigBuilder)this.runConfigBuilder.withImage(image));
    }

    public RunOperations withName(String name) {
        return new RunOperations(this.client, this.config, this.namespace, (RunConfigBuilder)this.runConfigBuilder.withName(name));
    }

    public RunOperations withRunConfig(RunConfig generatorRunConfig) {
        return new RunOperations(this.client, this.config, this.namespace, new RunConfigBuilder(generatorRunConfig));
    }

    public Pod done() {
        return new PodOperationsImpl(this.client, this.config, this.namespace).create(this.convertRunConfigIntoPod());
    }

    Pod convertRunConfigIntoPod() {
        EditableRunConfig finalGeneratorConfig = this.runConfigBuilder.build();
        return ((PodBuilder)((PodBuilder)new PodBuilder().withMetadata(RunConfigUtil.getObjectMetadataFromRunConfig(finalGeneratorConfig))).withSpec(RunConfigUtil.getPodSpecFromRunConfig(finalGeneratorConfig))).build();
    }
}

