/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.dsl.internal;

import java.util.Objects;

abstract class NamedRunnable
implements Runnable {
    private final String name;

    NamedRunnable(String name) {
        this.name = Objects.requireNonNull(name);
    }

    private void tryToSetName(String value) {
        try {
            Thread.currentThread().setName(value);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public final void run() {
        String oldName = Thread.currentThread().getName();
        this.tryToSetName(this.name + "|" + oldName);
        try {
            this.execute();
        }
        finally {
            this.tryToSetName(oldName);
        }
    }

    protected abstract void execute();
}

