/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1.extensions;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetStatusBuilder;
import io.fabric8.kubernetes.api.model.v5_1.extensions.DaemonSetStatusFluentImpl;
import java.util.Objects;

public class DaemonSetFluentImpl<A extends DaemonSetFluent<A>>
extends BaseFluent<A>
implements DaemonSetFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DaemonSetSpecBuilder spec;
    private DaemonSetStatusBuilder status;

    public DaemonSetFluentImpl() {
    }

    public DaemonSetFluentImpl(DaemonSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public DaemonSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public DaemonSetSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public DaemonSetSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(DaemonSetSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new DaemonSetSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public DaemonSetFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DaemonSetFluent.SpecNested<A> withNewSpecLike(DaemonSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DaemonSetFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new DaemonSetSpecBuilder().build());
    }

    @Override
    public DaemonSetFluent.SpecNested<A> editOrNewSpecLike(DaemonSetSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public DaemonSetStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public DaemonSetStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(DaemonSetStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new DaemonSetStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public DaemonSetFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DaemonSetFluent.StatusNested<A> withNewStatusLike(DaemonSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public DaemonSetFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new DaemonSetStatusBuilder().build());
    }

    @Override
    public DaemonSetFluent.StatusNested<A> editOrNewStatusLike(DaemonSetStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonSetFluentImpl that = (DaemonSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends DaemonSetStatusFluentImpl<DaemonSetFluent.StatusNested<N>>
    implements DaemonSetFluent.StatusNested<N>,
    Nested<N> {
        private final DaemonSetStatusBuilder builder;

        StatusNestedImpl(DaemonSetStatus item) {
            this.builder = new DaemonSetStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new DaemonSetStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DaemonSetSpecFluentImpl<DaemonSetFluent.SpecNested<N>>
    implements DaemonSetFluent.SpecNested<N>,
    Nested<N> {
        private final DaemonSetSpecBuilder builder;

        SpecNestedImpl(DaemonSetSpec item) {
            this.builder = new DaemonSetSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DaemonSetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DaemonSetFluent.MetadataNested<N>>
    implements DaemonSetFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

