/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v5_1.autoscaling.v1.ScaleFluent;
import io.fabric8.kubernetes.api.model.v5_1.autoscaling.v1.ScaleFluentImpl;
import java.util.Objects;

public class ScaleBuilder
extends ScaleFluentImpl<ScaleBuilder>
implements VisitableBuilder<Scale, ScaleBuilder> {
    ScaleFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleBuilder() {
        this(true);
    }

    public ScaleBuilder(Boolean validationEnabled) {
        this(new Scale(), validationEnabled);
    }

    public ScaleBuilder(ScaleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Scale(), validationEnabled);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance) {
        this(fluent, instance, true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ScaleBuilder(Scale instance) {
        this(instance, (Boolean)true);
    }

    public ScaleBuilder(Scale instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Scale build() {
        Scale buildable = new Scale(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleBuilder that = (ScaleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

