/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1.apps;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v5_1.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_1.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetUpdateStrategyBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetUpdateStrategyFluentImpl;
import java.util.Objects;

public class DaemonSetSpecFluentImpl<A extends DaemonSetSpecFluent<A>>
extends BaseFluent<A>
implements DaemonSetSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private PodTemplateSpecBuilder template;
    private DaemonSetUpdateStrategyBuilder updateStrategy;

    public DaemonSetSpecFluentImpl() {
    }

    public DaemonSetSpecFluentImpl(DaemonSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public DaemonSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public DaemonSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DaemonSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public DaemonSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(DaemonSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new DaemonSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(DaemonSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new DaemonSetUpdateStrategyBuilder().build());
    }

    @Override
    public DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(DaemonSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.revisionHistoryLimit, this.selector, this.template, this.updateStrategy, super.hashCode());
    }

    public class UpdateStrategyNestedImpl<N>
    extends DaemonSetUpdateStrategyFluentImpl<DaemonSetSpecFluent.UpdateStrategyNested<N>>
    implements DaemonSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        private final DaemonSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(DaemonSetUpdateStrategy item) {
            this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new DaemonSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DaemonSetSpecFluent.TemplateNested<N>>
    implements DaemonSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<DaemonSetSpecFluent.SelectorNested<N>>
    implements DaemonSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

