/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.AuthInfo;
import io.fabric8.kubernetes.api.model.v5_1.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.v5_1.AuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v5_1.NamedAuthInfoFluent;
import java.util.Objects;

public class NamedAuthInfoFluentImpl<A extends NamedAuthInfoFluent<A>>
extends BaseFluent<A>
implements NamedAuthInfoFluent<A> {
    private String name;
    private AuthInfoBuilder user;

    public NamedAuthInfoFluentImpl() {
    }

    public NamedAuthInfoFluentImpl(NamedAuthInfo instance) {
        this.withName(instance.getName());
        this.withUser(instance.getUser());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public AuthInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public AuthInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(AuthInfo user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new AuthInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> withNewUserLike(AuthInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new AuthInfoBuilder().build());
    }

    @Override
    public NamedAuthInfoFluent.UserNested<A> editOrNewUserLike(AuthInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedAuthInfoFluentImpl that = (NamedAuthInfoFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.user, super.hashCode());
    }

    public class UserNestedImpl<N>
    extends AuthInfoFluentImpl<NamedAuthInfoFluent.UserNested<N>>
    implements NamedAuthInfoFluent.UserNested<N>,
    Nested<N> {
        private final AuthInfoBuilder builder;

        UserNestedImpl(AuthInfo item) {
            this.builder = new AuthInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new AuthInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedAuthInfoFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

