/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.HostAlias;
import io.fabric8.kubernetes.api.model.v5_1.HostAliasFluent;
import io.fabric8.kubernetes.api.model.v5_1.HostAliasFluentImpl;
import java.util.Objects;

public class HostAliasBuilder
extends HostAliasFluentImpl<HostAliasBuilder>
implements VisitableBuilder<HostAlias, HostAliasBuilder> {
    HostAliasFluent<?> fluent;
    Boolean validationEnabled;

    public HostAliasBuilder() {
        this(true);
    }

    public HostAliasBuilder(Boolean validationEnabled) {
        this(new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HostAlias(), validationEnabled);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, HostAlias instance) {
        this(fluent, instance, true);
    }

    public HostAliasBuilder(HostAliasFluent<?> fluent, HostAlias instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostnames(instance.getHostnames());
        fluent.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    public HostAliasBuilder(HostAlias instance) {
        this(instance, (Boolean)true);
    }

    public HostAliasBuilder(HostAlias instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HostAlias build() {
        HostAlias buildable = new HostAlias(this.fluent.getHostnames(), this.fluent.getIp());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostAliasBuilder that = (HostAliasBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

