/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.APIGroup;
import io.fabric8.kubernetes.api.model.v5_1.APIGroupFluent;
import io.fabric8.kubernetes.api.model.v5_1.GroupVersionForDiscovery;
import io.fabric8.kubernetes.api.model.v5_1.GroupVersionForDiscoveryBuilder;
import io.fabric8.kubernetes.api.model.v5_1.GroupVersionForDiscoveryFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.ServerAddressByClientCIDR;
import io.fabric8.kubernetes.api.model.v5_1.ServerAddressByClientCIDRBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ServerAddressByClientCIDRFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class APIGroupFluentImpl<A extends APIGroupFluent<A>>
extends BaseFluent<A>
implements APIGroupFluent<A> {
    private String apiVersion;
    private String kind;
    private String name;
    private GroupVersionForDiscoveryBuilder preferredVersion;
    private List<ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
    private List<GroupVersionForDiscoveryBuilder> versions = new ArrayList<GroupVersionForDiscoveryBuilder>();

    public APIGroupFluentImpl() {
    }

    public APIGroupFluentImpl(APIGroup instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    @Deprecated
    public GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion != null ? this.preferredVersion.build() : null;
    }

    @Override
    public GroupVersionForDiscovery buildPreferredVersion() {
        return this.preferredVersion != null ? this.preferredVersion.build() : null;
    }

    @Override
    public A withPreferredVersion(GroupVersionForDiscovery preferredVersion) {
        this._visitables.get("preferredVersion").remove(this.preferredVersion);
        if (preferredVersion != null) {
            this.preferredVersion = new GroupVersionForDiscoveryBuilder(preferredVersion);
            this._visitables.get("preferredVersion").add(this.preferredVersion);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreferredVersion() {
        return this.preferredVersion != null;
    }

    @Override
    public A withNewPreferredVersion(String groupVersion, String version) {
        return this.withPreferredVersion(new GroupVersionForDiscovery(groupVersion, version));
    }

    @Override
    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion() {
        return new PreferredVersionNestedImpl();
    }

    @Override
    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item) {
        return new PreferredVersionNestedImpl(item);
    }

    @Override
    public APIGroupFluent.PreferredVersionNested<A> editPreferredVersion() {
        return this.withNewPreferredVersionLike(this.getPreferredVersion());
    }

    @Override
    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion() {
        return this.withNewPreferredVersionLike(this.getPreferredVersion() != null ? this.getPreferredVersion() : new GroupVersionForDiscoveryBuilder().build());
    }

    @Override
    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item) {
        return this.withNewPreferredVersionLike(this.getPreferredVersion() != null ? this.getPreferredVersion() : item);
    }

    @Override
    public A addToServerAddressByClientCIDRs(int index, ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
        }
        ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
        this._visitables.get("serverAddressByClientCIDRs").add(index >= 0 ? index : this._visitables.get("serverAddressByClientCIDRs").size(), builder);
        this.serverAddressByClientCIDRs.add(index >= 0 ? index : this.serverAddressByClientCIDRs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServerAddressByClientCIDRs(int index, ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
        }
        ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
        if (index < 0 || index >= this._visitables.get("serverAddressByClientCIDRs").size()) {
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
        } else {
            this._visitables.get("serverAddressByClientCIDRs").set(index, builder);
        }
        if (index < 0 || index >= this.serverAddressByClientCIDRs.size()) {
            this.serverAddressByClientCIDRs.add(builder);
        } else {
            this.serverAddressByClientCIDRs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServerAddressByClientCIDRs(ServerAddressByClientCIDR ... items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServerAddressByClientCIDRs(ServerAddressByClientCIDR ... items) {
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            if (this.serverAddressByClientCIDRs == null) continue;
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServerAddressByClientCIDRs(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        Iterator<ServerAddressByClientCIDRBuilder> each = this.serverAddressByClientCIDRs.iterator();
        Object visitables = this._visitables.get("serverAddressByClientCIDRs");
        while (each.hasNext()) {
            ServerAddressByClientCIDRBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return APIGroupFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
        return APIGroupFluentImpl.build(this.serverAddressByClientCIDRs);
    }

    @Override
    public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index) {
        return this.serverAddressByClientCIDRs.get(index).build();
    }

    @Override
    public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(0).build();
    }

    @Override
    public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(this.serverAddressByClientCIDRs.size() - 1).build();
    }

    @Override
    public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        for (ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        for (ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this._visitables.get("serverAddressByClientCIDRs").removeAll(this.serverAddressByClientCIDRs);
        }
        if (serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDRBuilder>();
            for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        } else {
            this.serverAddressByClientCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withServerAddressByClientCIDRs(ServerAddressByClientCIDR ... serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs.clear();
        }
        if (serverAddressByClientCIDRs != null) {
            for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty();
    }

    @Override
    public A addNewServerAddressByClientCIDR(String clientCIDR, String serverAddress) {
        return this.addToServerAddressByClientCIDRs(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
        return new ServerAddressByClientCIDRsNestedImpl();
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(-1, item);
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index, ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNestedImpl(index, item);
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index) {
        if (this.serverAddressByClientCIDRs.size() <= index) {
            throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
        if (this.serverAddressByClientCIDRs.size() == 0) {
            throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(0, this.buildServerAddressByClientCIDR(0));
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
        int index = this.serverAddressByClientCIDRs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serverAddressByClientCIDRs.size(); ++i) {
            if (!predicate.test(this.serverAddressByClientCIDRs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    @Override
    public A addToVersions(int index, GroupVersionForDiscovery item) {
        if (this.versions == null) {
            this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
        }
        GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
        this._visitables.get("versions").add(index >= 0 ? index : this._visitables.get("versions").size(), builder);
        this.versions.add(index >= 0 ? index : this.versions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, GroupVersionForDiscovery item) {
        if (this.versions == null) {
            this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
        }
        GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
        if (index < 0 || index >= this._visitables.get("versions").size()) {
            this._visitables.get("versions").add(builder);
        } else {
            this._visitables.get("versions").set(index, builder);
        }
        if (index < 0 || index >= this.versions.size()) {
            this.versions.add(builder);
        } else {
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVersions(GroupVersionForDiscovery ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
        }
        for (GroupVersionForDiscovery item : items) {
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<GroupVersionForDiscovery> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
        }
        for (GroupVersionForDiscovery item : items) {
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(GroupVersionForDiscovery ... items) {
        for (GroupVersionForDiscovery item : items) {
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items) {
        for (GroupVersionForDiscovery item : items) {
            GroupVersionForDiscoveryBuilder builder = new GroupVersionForDiscoveryBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVersions(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<GroupVersionForDiscoveryBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            GroupVersionForDiscoveryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GroupVersionForDiscovery> getVersions() {
        return APIGroupFluentImpl.build(this.versions);
    }

    @Override
    public List<GroupVersionForDiscovery> buildVersions() {
        return APIGroupFluentImpl.build(this.versions);
    }

    @Override
    public GroupVersionForDiscovery buildVersion(int index) {
        return this.versions.get(index).build();
    }

    @Override
    public GroupVersionForDiscovery buildFirstVersion() {
        return this.versions.get(0).build();
    }

    @Override
    public GroupVersionForDiscovery buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    @Override
    public GroupVersionForDiscovery buildMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
        for (GroupVersionForDiscoveryBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
        for (GroupVersionForDiscoveryBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVersions(List<GroupVersionForDiscovery> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").removeAll(this.versions);
        }
        if (versions != null) {
            this.versions = new ArrayList<GroupVersionForDiscoveryBuilder>();
            for (GroupVersionForDiscovery item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    @Override
    public A withVersions(GroupVersionForDiscovery ... versions) {
        if (this.versions != null) {
            this.versions.clear();
        }
        if (versions != null) {
            for (GroupVersionForDiscovery item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public A addNewVersion(String groupVersion, String version) {
        return this.addToVersions(new GroupVersionForDiscovery(groupVersion, version));
    }

    @Override
    public APIGroupFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public APIGroupFluent.VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item) {
        return new VersionsNestedImpl(-1, item);
    }

    @Override
    public APIGroupFluent.VersionsNested<A> setNewVersionLike(int index, GroupVersionForDiscovery item) {
        return new VersionsNestedImpl(index, item);
    }

    @Override
    public APIGroupFluent.VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public APIGroupFluent.VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    @Override
    public APIGroupFluent.VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public APIGroupFluent.VersionsNested<A> editMatchingVersion(Predicate<GroupVersionForDiscoveryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIGroupFluentImpl that = (APIGroupFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.preferredVersion != null ? !this.preferredVersion.equals(that.preferredVersion) : that.preferredVersion != null) {
            return false;
        }
        if (this.serverAddressByClientCIDRs != null ? !this.serverAddressByClientCIDRs.equals(that.serverAddressByClientCIDRs) : that.serverAddressByClientCIDRs != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.preferredVersion, this.serverAddressByClientCIDRs, this.versions, super.hashCode());
    }

    public class VersionsNestedImpl<N>
    extends GroupVersionForDiscoveryFluentImpl<APIGroupFluent.VersionsNested<N>>
    implements APIGroupFluent.VersionsNested<N>,
    Nested<N> {
        private final GroupVersionForDiscoveryBuilder builder;
        private final int index;

        VersionsNestedImpl(int index, GroupVersionForDiscovery item) {
            this.index = index;
            this.builder = new GroupVersionForDiscoveryBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new GroupVersionForDiscoveryBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIGroupFluentImpl.this.setToVersions(this.index, this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class ServerAddressByClientCIDRsNestedImpl<N>
    extends ServerAddressByClientCIDRFluentImpl<APIGroupFluent.ServerAddressByClientCIDRsNested<N>>
    implements APIGroupFluent.ServerAddressByClientCIDRsNested<N>,
    Nested<N> {
        private final ServerAddressByClientCIDRBuilder builder;
        private final int index;

        ServerAddressByClientCIDRsNestedImpl(int index, ServerAddressByClientCIDR item) {
            this.index = index;
            this.builder = new ServerAddressByClientCIDRBuilder(this, item);
        }

        ServerAddressByClientCIDRsNestedImpl() {
            this.index = -1;
            this.builder = new ServerAddressByClientCIDRBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIGroupFluentImpl.this.setToServerAddressByClientCIDRs(this.index, this.builder.build());
        }

        @Override
        public N endServerAddressByClientCIDR() {
            return this.and();
        }
    }

    public class PreferredVersionNestedImpl<N>
    extends GroupVersionForDiscoveryFluentImpl<APIGroupFluent.PreferredVersionNested<N>>
    implements APIGroupFluent.PreferredVersionNested<N>,
    Nested<N> {
        private final GroupVersionForDiscoveryBuilder builder;

        PreferredVersionNestedImpl(GroupVersionForDiscovery item) {
            this.builder = new GroupVersionForDiscoveryBuilder(this, item);
        }

        PreferredVersionNestedImpl() {
            this.builder = new GroupVersionForDiscoveryBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIGroupFluentImpl.this.withPreferredVersion(this.builder.build());
        }

        @Override
        public N endPreferredVersion() {
            return this.and();
        }
    }
}

