/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_0.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.openshift.api.model.v5_0.operator.v1.StaticIPAMDNS;
import io.fabric8.openshift.api.model.v5_0.operator.v1.StaticIPAMDNSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class StaticIPAMDNSFluentImpl<A extends StaticIPAMDNSFluent<A>>
extends BaseFluent<A>
implements StaticIPAMDNSFluent<A> {
    private String domain;
    private List<String> nameservers = new ArrayList<String>();
    private List<String> search = new ArrayList<String>();

    public StaticIPAMDNSFluentImpl() {
    }

    public StaticIPAMDNSFluentImpl(StaticIPAMDNS instance) {
        this.withDomain(instance.getDomain());
        this.withNameservers(instance.getNameservers());
        this.withSearch(instance.getSearch());
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    public A withNewDomain(String arg1) {
        return this.withDomain(new String(arg1));
    }

    @Override
    public A withNewDomain(StringBuilder arg1) {
        return this.withDomain(new String(arg1));
    }

    @Override
    public A withNewDomain(StringBuffer arg1) {
        return this.withDomain(new String(arg1));
    }

    @Override
    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameservers(String ... items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameservers() {
        return this.nameservers;
    }

    @Override
    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    @Override
    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    @Override
    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    @Override
    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameservers(List<String> nameservers) {
        if (this.nameservers != null) {
            this._visitables.get("nameservers").removeAll(this.nameservers);
        }
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    @Override
    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    @Override
    public A addNewNameserver(String arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addNewNameserver(StringBuilder arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addNewNameserver(StringBuffer arg1) {
        return this.addToNameservers(new String(arg1));
    }

    @Override
    public A addToSearch(int index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSearch(int index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSearch(String ... items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSearch(Collection<String> items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSearch(String ... items) {
        for (String item : items) {
            if (this.search == null) continue;
            this.search.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSearch(Collection<String> items) {
        for (String item : items) {
            if (this.search == null) continue;
            this.search.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSearch() {
        return this.search;
    }

    @Override
    public String getSearch(int index) {
        return this.search.get(index);
    }

    @Override
    public String getFirstSearch() {
        return this.search.get(0);
    }

    @Override
    public String getLastSearch() {
        return this.search.get(this.search.size() - 1);
    }

    @Override
    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSearch(List<String> search) {
        if (this.search != null) {
            this._visitables.get("search").removeAll(this.search);
        }
        if (search != null) {
            this.search = new ArrayList<String>();
            for (String item : search) {
                this.addToSearch(item);
            }
        } else {
            this.search = null;
        }
        return (A)this;
    }

    @Override
    public A withSearch(String ... search) {
        if (this.search != null) {
            this.search.clear();
        }
        if (search != null) {
            for (String item : search) {
                this.addToSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearch() {
        return this.search != null && !this.search.isEmpty();
    }

    @Override
    public A addNewSearch(String arg1) {
        return this.addToSearch(new String(arg1));
    }

    @Override
    public A addNewSearch(StringBuilder arg1) {
        return this.addToSearch(new String(arg1));
    }

    @Override
    public A addNewSearch(StringBuffer arg1) {
        return this.addToSearch(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticIPAMDNSFluentImpl that = (StaticIPAMDNSFluentImpl)o;
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) {
            return false;
        }
        return !(this.search != null ? !this.search.equals(that.search) : that.search != null);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.nameservers, this.search, super.hashCode());
    }
}

