/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v5_0.KubernetesList;
import io.fabric8.kubernetes.clnt.v5_0.utils.Serialization;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceCompare {
    private static TypeReference<HashMap<String, Object>> TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private static final String METADATA = "metadata";
    private static final String SPEC = "spec";
    private static final String ITEMS = "items";

    private ResourceCompare() {
    }

    public static <T> boolean equals(T left, T right) {
        ObjectMapper jsonMapper = Serialization.jsonMapper();
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        Map leftJson = (Map)jsonMapper.convertValue(left, TYPE_REF);
        Map rightJson = (Map)jsonMapper.convertValue(right, TYPE_REF);
        if (left instanceof KubernetesList) {
            return ResourceCompare.compareKubernetesList(leftJson, rightJson);
        }
        return ResourceCompare.compareKubernetesResource(leftJson, rightJson);
    }

    public static boolean compareKubernetesList(Map<String, Object> leftJson, Map<String, Object> rightJson) {
        List leftItems = (List)leftJson.get(ITEMS);
        List rightItems = (List)rightJson.get(ITEMS);
        if (leftItems != null && rightItems != null) {
            if (leftItems.size() != rightItems.size()) {
                return false;
            }
            for (int i = 0; i < rightItems.size(); ++i) {
                if (ResourceCompare.compareKubernetesResource((Map)leftItems.get(i), (Map)rightItems.get(i))) continue;
                return false;
            }
        } else {
            return leftItems != null;
        }
        return true;
    }

    public static boolean compareKubernetesResource(Map<String, Object> leftJson, Map<String, Object> rightJson) {
        return ResourceCompare.isEqualMetadata(leftJson, rightJson) && ResourceCompare.isEqualSpec(leftJson, rightJson);
    }

    private static boolean isEqualMetadata(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        Map leftMetadata = (Map)leftMap.get(METADATA);
        Map rightMetadata = (Map)rightMap.get(METADATA);
        if (leftMetadata == null && rightMetadata == null) {
            return true;
        }
        if (leftMetadata != null && rightMetadata == null) {
            return true;
        }
        if (leftMetadata == null) {
            return false;
        }
        return ResourceCompare.isLeftMapSupersetOfRight(leftMetadata, rightMetadata);
    }

    private static boolean isEqualSpec(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        Map leftSpec = (Map)leftMap.get(SPEC);
        Map rightSpec = (Map)rightMap.get(SPEC);
        if (leftSpec == null && rightSpec == null) {
            return true;
        }
        if (leftSpec != null && rightSpec == null) {
            return true;
        }
        if (leftSpec == null) {
            return false;
        }
        return ResourceCompare.isLeftMapSupersetOfRight(leftSpec, rightSpec);
    }

    private static boolean isLeftMapSupersetOfRight(Map<String, Object> leftMap, Map<String, Object> rightMap) {
        for (Map.Entry<String, Object> entry : rightMap.entrySet()) {
            if (!leftMap.containsKey(entry.getKey())) {
                return false;
            }
            if (leftMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

