/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.informers.cache;

import io.fabric8.kubernetes.clnt.v5_0.informers.cache.Indexer;
import java.util.List;

public class Lister<T> {
    private String namespace;
    private String indexName;
    private Indexer<T> indexer;

    public Lister(Indexer<T> indexer) {
        this(indexer, null, "namespace");
    }

    public Lister(Indexer<T> indexer, String namespace) {
        this(indexer, namespace, "namespace");
    }

    public Lister(Indexer<T> indexer, String namespace, String indexName) {
        this.indexer = indexer;
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public List<T> list() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            return this.indexer.list();
        }
        return this.indexer.byIndex(this.indexName, this.namespace);
    }

    public T get(String name) {
        String key = name;
        if (this.namespace != null && !this.namespace.isEmpty()) {
            key = this.namespace + "/" + name;
        }
        return this.indexer.getByKey(key);
    }

    public Lister<T> namespace(String namespace) {
        return new Lister<T>(this.indexer, namespace, "namespace");
    }
}

