/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_0.KubernetesResource;
import io.fabric8.kubernetes.api.model.v5_0.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.CustomResourceList;
import io.fabric8.kubernetes.clnt.v5_0.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_0.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v5_0.internal.KubernetesDeserializer;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends HasMetadataOperation<T, L, Resource<T>>
implements MixedOperation<T, L, Resource<T>> {
    private final boolean resourceNamespaced;

    public CustomResourceOperationsImpl(OkHttpClient client, Config config) {
        this(new CustomResourceOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public CustomResourceOperationsImpl(CustomResourceOperationContext context) {
        super(context.withApiGroupName(context.getCrdContext().getGroup()).withApiGroupVersion(context.getCrdContext().getVersion()).withPlural(context.getCrdContext().getPlural()));
        this.type = context.getType();
        this.listType = context.getListType() != null ? context.getListType() : CustomResourceOperationsImpl.inferListType(this.type);
        this.resourceNamespaced = CustomResourceOperationsImpl.resourceNamespaced(context.getCrdContext());
        this.apiVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        KubernetesDeserializer.registerCustomKind(this.apiVersion, this.kind(context.getCrdContext()), this.type);
        if (KubernetesResource.class.isAssignableFrom(this.listType)) {
            KubernetesDeserializer.registerCustomKind(this.listType.getSimpleName(), this.listType);
        }
    }

    public CustomResourceOperationsImpl newInstance(OperationContext context) {
        return new CustomResourceOperationsImpl<T, L>((CustomResourceOperationContext)context);
    }

    protected static boolean resourceNamespaced(CustomResourceDefinitionContext crdContext) {
        return "Namespaced".equals(crdContext.getScope());
    }

    private String kind(CustomResourceDefinitionContext crdContext) {
        return crdContext.getKind() != null ? crdContext.getKind() : this.getKind();
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.resourceNamespaced;
    }

    public static <T extends HasMetadata> Class<? extends KubernetesResourceList> inferListType(Class<T> customResource) {
        try {
            return Class.forName(customResource.getName() + "List");
        }
        catch (ClassNotFoundException e) {
            return CustomResourceList.class;
        }
    }
}

