/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0.node.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_0.Quantity;
import io.fabric8.kubernetes.api.model.v5_0.node.v1beta1.Overhead;
import io.fabric8.kubernetes.api.model.v5_0.node.v1beta1.OverheadFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class OverheadFluentImpl<A extends OverheadFluent<A>>
extends BaseFluent<A>
implements OverheadFluent<A> {
    private Map<String, Quantity> podFixed;

    public OverheadFluentImpl() {
    }

    public OverheadFluentImpl(Overhead instance) {
        this.withPodFixed(instance.getPodFixed());
    }

    @Override
    public A addToPodFixed(String key, Quantity value) {
        if (this.podFixed == null && key != null && value != null) {
            this.podFixed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.podFixed.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPodFixed(Map<String, Quantity> map) {
        if (this.podFixed == null && map != null) {
            this.podFixed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.podFixed.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodFixed(String key) {
        if (this.podFixed == null) {
            return (A)this;
        }
        if (key != null && this.podFixed != null) {
            this.podFixed.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodFixed(Map<String, Quantity> map) {
        if (this.podFixed == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.podFixed == null) continue;
                this.podFixed.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getPodFixed() {
        return this.podFixed;
    }

    @Override
    public A withPodFixed(Map<String, Quantity> podFixed) {
        this.podFixed = podFixed == null ? null : new LinkedHashMap<String, Quantity>(podFixed);
        return (A)this;
    }

    @Override
    public Boolean hasPodFixed() {
        return this.podFixed != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverheadFluentImpl that = (OverheadFluentImpl)o;
        return !(this.podFixed != null ? !this.podFixed.equals(that.podFixed) : that.podFixed != null);
    }

    public int hashCode() {
        return Objects.hash(this.podFixed, super.hashCode());
    }
}

