/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_0.Nested;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.NonResourceAttributes;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.NonResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.NonResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.ResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.SubjectAccessReviewSpec;
import io.fabric8.kubernetes.api.model.v5_0.authorization.v1beta1.SubjectAccessReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubjectAccessReviewSpecFluentImpl<A extends SubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A>
implements SubjectAccessReviewSpecFluent<A> {
    private Map<String, ArrayList<String>> extra;
    private List<String> group = new ArrayList<String>();
    private NonResourceAttributesBuilder nonResourceAttributes;
    private ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;

    public SubjectAccessReviewSpecFluentImpl() {
    }

    public SubjectAccessReviewSpecFluentImpl(SubjectAccessReviewSpec instance) {
        this.withExtra(instance.getExtra());
        this.withGroup(instance.getGroup());
        this.withNonResourceAttributes(instance.getNonResourceAttributes());
        this.withResourceAttributes(instance.getResourceAttributes());
        this.withUid(instance.getUid());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToExtra(String key, ArrayList<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, ArrayList<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, ArrayList<String>>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroup(String ... items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroup(Collection<String> items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroup(String ... items) {
        for (String item : items) {
            if (this.group == null) continue;
            this.group.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroup(Collection<String> items) {
        for (String item : items) {
            if (this.group == null) continue;
            this.group.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroup() {
        return this.group;
    }

    @Override
    public String getGroup(int index) {
        return this.group.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.group.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.group.get(this.group.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroup(List<String> group) {
        if (this.group != null) {
            this._visitables.get("group").removeAll(this.group);
        }
        if (group != null) {
            this.group = new ArrayList<String>();
            for (String item : group) {
                this.addToGroup(item);
            }
        } else {
            this.group = null;
        }
        return (A)this;
    }

    @Override
    public A withGroup(String ... group) {
        if (this.group != null) {
            this.group.clear();
        }
        if (group != null) {
            for (String item : group) {
                this.addToGroup(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    @Override
    public A addNewGroup(String arg1) {
        return this.addToGroup(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuilder arg1) {
        return this.addToGroup(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuffer arg1) {
        return this.addToGroup(new String(arg1));
    }

    @Override
    @Deprecated
    public NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
        this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    @Override
    public A withNewNonResourceAttributes(String path, String verb) {
        return this.withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
        return new NonResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : new NonResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : item);
    }

    @Override
    @Deprecated
    public ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public A withResourceAttributes(ResourceAttributes resourceAttributes) {
        this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        if (resourceAttributes != null) {
            this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
            this._visitables.get("resourceAttributes").add(this.resourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
        return new ResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : new ResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : item);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A withNewUser(String arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuilder arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuffer arg1) {
        return this.withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl)o;
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.nonResourceAttributes != null ? !this.nonResourceAttributes.equals(that.nonResourceAttributes) : that.nonResourceAttributes != null) {
            return false;
        }
        if (this.resourceAttributes != null ? !this.resourceAttributes.equals(that.resourceAttributes) : that.resourceAttributes != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.group, this.nonResourceAttributes, this.resourceAttributes, this.uid, this.user, super.hashCode());
    }

    public class ResourceAttributesNestedImpl<N>
    extends ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,
    Nested<N> {
        private final ResourceAttributesBuilder builder;

        ResourceAttributesNestedImpl(ResourceAttributes item) {
            this.builder = new ResourceAttributesBuilder(this, item);
        }

        ResourceAttributesNestedImpl() {
            this.builder = new ResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(this.builder.build());
        }

        @Override
        public N endResourceAttributes() {
            return this.and();
        }
    }

    public class NonResourceAttributesNestedImpl<N>
    extends NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,
    Nested<N> {
        private final NonResourceAttributesBuilder builder;

        NonResourceAttributesNestedImpl(NonResourceAttributes item) {
            this.builder = new NonResourceAttributesBuilder(this, item);
        }

        NonResourceAttributesNestedImpl() {
            this.builder = new NonResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(this.builder.build());
        }

        @Override
        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

