/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.internal.readiness;

import io.fabric8.kubernetes.api.model.v5_0.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_0.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_0.utils.Utils;
import io.fabric8.openshift.api.model.v5_0.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_0.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.v5_0.DeploymentConfigStatus;

public class OpenShiftReadiness
extends Readiness {
    public static boolean isReadinessApplicable(Class<? extends HasMetadata> itemClass) {
        return Readiness.isReadinessApplicable(itemClass) || DeploymentConfig.class.isAssignableFrom(itemClass);
    }

    public static boolean isReady(HasMetadata item) {
        if (Readiness.isReadiableKubernetesResource(item)) {
            return Readiness.isReady(item);
        }
        if (item instanceof DeploymentConfig) {
            return OpenShiftReadiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        throw new IllegalArgumentException("Item needs to be one of [Node, Deployment, ReplicaSet, StatefulSet, Pod, DeploymentConfig, ReplicationController], but was: [" + (item != null ? item.getKind() : "Unknown (null)") + "]");
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }
}

