/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.handlers;

import io.fabric8.kubernetes.api.model.v5_0.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_0.ListOptions;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_0.Watch;
import io.fabric8.kubernetes.clnt.v5_0.Watcher;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Resource;
import io.fabric8.openshift.api.model.v5_0.Image;
import io.fabric8.openshift.api.model.v5_0.ImageBuilder;
import io.fabric8.openshift.clnt.v5_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.ImageOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageHandler
implements ResourceHandler<Image, ImageBuilder> {
    @Override
    public String getKind() {
        return Image.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public Image create(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Image[0]);
    }

    @Override
    public Image replace(OkHttpClient client, Config config, String namespace, Image item) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Image reload(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Gettable)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageBuilder edit(Image item) {
        return new ImageBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Image item) {
        return new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, String resourceVersion, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, ListOptions options, Watcher<Image> watcher) {
        return ((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Image waitUntilReady(OkHttpClient client, Config config, String namespace, Image item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Image waitUntilCondition(OkHttpClient client, Config config, String namespace, Image item, Predicate<Image> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

