/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_0.dsl.internal;

import io.fabric8.kubernetes.api.builder.v5_0.Visitor;
import io.fabric8.kubernetes.api.model.v5_0.Event;
import io.fabric8.kubernetes.api.model.v5_0.EventList;
import io.fabric8.kubernetes.clnt.v5_0.Config;
import io.fabric8.kubernetes.clnt.v5_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_0.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Triggerable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.Typeable;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_0.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_0.dsl.internal.core.v1.EventOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_0.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_0.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_0.utils.Utils;
import io.fabric8.openshift.api.model.v5_0.Build;
import io.fabric8.openshift.api.model.v5_0.BuildConfig;
import io.fabric8.openshift.api.model.v5_0.BuildConfigBuilder;
import io.fabric8.openshift.api.model.v5_0.BuildConfigList;
import io.fabric8.openshift.api.model.v5_0.BuildList;
import io.fabric8.openshift.api.model.v5_0.BuildRequest;
import io.fabric8.openshift.api.model.v5_0.WebHookTrigger;
import io.fabric8.openshift.clnt.v5_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_0.dsl.BuildConfigOperation;
import io.fabric8.openshift.clnt.v5_0.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_0.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_0.dsl.InputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.TimeoutInputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.AsFileTimeoutInputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.AuthorEmailable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.AuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.CommitterAuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.CommitterEmailable;
import io.fabric8.openshift.clnt.v5_0.dsl.buildconfig.MessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.BuildConfigOperationContext;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_0.dsl.internal.OpenShiftOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigOperationsImpl
extends OpenShiftOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>>
implements BuildConfigOperation {
    private static final Logger logger = LoggerFactory.getLogger(BuildConfigOperationsImpl.class);
    public static final String BUILD_CONFIG_LABEL = "openshift.io/build-config.name";
    public static final String BUILD_CONFIG_ANNOTATION = "openshift.io/build-config.name";
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new BuildConfigOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public BuildConfigOperationsImpl(BuildConfigOperationContext context) {
        super(context.withApiGroupName("build.openshift.io").withPlural("buildconfigs"));
        this.type = BuildConfig.class;
        this.listType = BuildConfigList.class;
        this.triggerType = context.getTriggerType();
        this.secret = context.getSecret();
        this.authorName = context.getAuthorName();
        this.authorEmail = context.getAuthorEmail();
        this.committerName = context.getCommitterName();
        this.committerEmail = context.getCommitterEmail();
        this.commit = context.getCommit();
        this.message = context.getMessage();
        this.asFile = context.getAsFile();
        this.timeout = context.getTimeout();
        this.timeoutUnit = context.getTimeoutUnit();
    }

    public BuildConfigOperationsImpl newInstance(OperationContext context) {
        return new BuildConfigOperationsImpl((BuildConfigOperationContext)context);
    }

    public BuildConfigOperationContext getContext() {
        return (BuildConfigOperationContext)this.context;
    }

    @Override
    public Build instantiate(BuildRequest request) {
        try {
            this.updateApiVersion(request);
            URL instantiationUrl = new URL(URLUtils.join(this.getResourceUrl().toString(), "instantiate"));
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)OperationSupport.JSON_MAPPER.writer().writeValueAsString((Object)request));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(instantiationUrl);
            return this.handleResponse(requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> instantiateBinary() {
        return new BuildConfigOperationsImpl(this.getContext());
    }

    @Override
    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join(this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType);
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (byte[])OperationSupport.JSON_MAPPER.writer().writeValueAsBytes((Object)trigger));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(triggerUrl).addHeader("X-Github-Event", "push");
            this.handleResponse(requestBuilder, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return null;
    }

    @Override
    public Triggerable<WebHookTrigger, Void> withType(String triggerType) {
        return new BuildConfigOperationsImpl(this.getContext().withTriggerType(triggerType));
    }

    @Override
    public BuildConfigResource<BuildConfig, Void, Build> withResourceVersion(String resourceVersion) {
        return new BuildConfigOperationsImpl(this.getContext().withResourceVersion(resourceVersion));
    }

    private void deleteBuilds() {
        if (this.getName() == null) {
            return;
        }
        String buildConfigLabelValue = this.getName().substring(0, Math.min(this.getName().length(), 63));
        BuildList matchingBuilds = (BuildList)((FilterWatchListDeletable)new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config).inNamespace(this.namespace).withLabel("openshift.io/build-config.name", buildConfigLabelValue)).list();
        if (matchingBuilds.getItems() != null) {
            for (Build matchingBuild : matchingBuilds.getItems()) {
                if (matchingBuild.getMetadata() == null || matchingBuild.getMetadata().getAnnotations() == null || !this.getName().equals(matchingBuild.getMetadata().getAnnotations().get("openshift.io/build-config.name"))) continue;
                ((BuildResource)new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config).inNamespace(matchingBuild.getMetadata().getNamespace()).withName(matchingBuild.getMetadata().getName())).delete();
            }
        }
    }

    @Override
    public Build fromInputStream(InputStream inputStream) {
        return this.fromInputStream(inputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Build fromFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Can't instantiate binary build from the specified file. The file does not exists");
        }
        try (FileInputStream is = new FileInputStream(file);){
            logger.debug("Uploading archive file \"{}\" as binary input for the build ...", (Object)file.getAbsolutePath());
            Build build = this.fromInputStream(is, file.length());
            return build;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private Build fromInputStream(InputStream inputStream, long contentLength) {
        return this.submitToApiServerWithRequestBody(new ArchiveFileInputStreamRequestBody(this.client, this.config, inputStream, contentLength, this.name, this.namespace));
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join(this.getResourceUrl().toString(), "instantiatebinary"));
        if (Utils.isNotNullOrEmpty(this.name)) {
            sb.append("?name=").append(this.name);
        }
        if (Utils.isNotNullOrEmpty(this.namespace)) {
            sb.append("&namespace=").append(this.namespace);
        }
        if (Utils.isNotNullOrEmpty(this.message)) {
            sb.append("&commit=").append(this.message);
        }
        if (!Utils.isNullOrEmpty(this.authorName)) {
            sb.append("&revision.authorName=").append(this.authorName);
        }
        if (!Utils.isNullOrEmpty(this.authorEmail)) {
            sb.append("&revision.authorEmail=").append(this.authorEmail);
        }
        if (!Utils.isNullOrEmpty(this.committerName)) {
            sb.append("&revision.committerName=").append(this.committerName);
        }
        if (!Utils.isNullOrEmpty(this.committerEmail)) {
            sb.append("&revision.committerEmail=").append(this.committerEmail);
        }
        if (!Utils.isNullOrEmpty(this.commit)) {
            sb.append("&revision.commit=").append(this.commit);
        }
        if (!Utils.isNullOrEmpty(this.asFile)) {
            sb.append("&asFile=").append(this.asFile);
        }
        return sb.toString();
    }

    @Override
    public TimeoutInputStreamable<Build> asFile(String fileName) {
        return new BuildConfigOperationsImpl(this.getContext().withAsFile(fileName));
    }

    @Override
    public MessageAsFileTimeoutInputStreamable<Build> withAuthorEmail(String email) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorEmail(email));
    }

    @Override
    public AuthorMessageAsFileTimeoutInputStreamable<Build> withCommitterEmail(String committerEmail) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterEmail(committerEmail));
    }

    @Override
    public AsFileTimeoutInputStreamable<Build> withMessage(String message) {
        return new BuildConfigOperationsImpl(this.getContext().withMessage(message));
    }

    @Override
    public AuthorEmailable<MessageAsFileTimeoutInputStreamable<Build>> withAuthorName(String authorName) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorName(authorName));
    }

    @Override
    public CommitterEmailable<AuthorMessageAsFileTimeoutInputStreamable<Build>> withCommitterName(String committerName) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterName(committerName));
    }

    @Override
    public InputStreamable<Build> withTimeout(long timeout, TimeUnit unit) {
        return new BuildConfigOperationsImpl(this.getContext().withTimeout(timeout).withTimeoutUnit(unit));
    }

    @Override
    public InputStreamable<Build> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.getContext().withSecret(secret));
    }

    @Override
    public BuildConfig edit(Visitor ... visitors) {
        return this.patch(((BuildConfigBuilder)new BuildConfigBuilder((BuildConfig)this.getMandatory()).accept(visitors)).build());
    }

    protected Build submitToApiServerWithRequestBody(RequestBody requestBody) {
        try {
            OkHttpClient newClient = this.client.newBuilder().readTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).build();
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).header("Expect", "100-continue").url(this.getQueryParameters());
            return this.handleResponse(newClient, requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static class ArchiveFileInputStreamRequestBody
    extends RequestBody {
        private long contentLength;
        private InputStream inputStream;
        private OkHttpClient okHttpClient;
        private Config clientConfig;
        private String name;
        private String namespace;

        public ArchiveFileInputStreamRequestBody(OkHttpClient client, Config config, InputStream inputStream, long contentLength, String name, String namespace) {
            this.contentLength = contentLength;
            this.inputStream = inputStream;
            this.okHttpClient = client;
            this.clientConfig = config;
            this.name = name;
            this.namespace = namespace;
        }

        public MediaType contentType() {
            return MediaType.parse((String)"application/octet-stream");
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try {
                this.writeToSink(sink);
            }
            catch (IOException e) {
                logger.error("Failed to upload archive file for the build: {}", (Object)this.name);
                logger.error("Please check cluster events via `oc get events` to see what could have possibly gone wrong");
                throw KubernetesClientException.launderThrowable("Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.See if something's wrong in recent events in Cluster = " + this.getRecentEvents(), (Throwable)e);
            }
        }

        public void writeToSink(BufferedSink sink) throws IOException {
            try (BufferedInputStream bis = new BufferedInputStream(this.inputStream);
                 Source source = Okio.source((InputStream)bis);){
                sink.writeAll(source);
            }
        }

        protected String getRecentEvents() {
            StringBuilder eventsAsStrBuilder = new StringBuilder();
            List<Event> recentEventList = ((EventList)new EventOperationsImpl(this.okHttpClient, this.clientConfig).inNamespace(this.namespace).list()).getItems();
            KubernetesResourceUtil.sortEventListBasedOnTimestamp(recentEventList);
            for (int i = 0; i < 10 && i < recentEventList.size(); ++i) {
                Event event = recentEventList.get(i);
                eventsAsStrBuilder.append(event.getReason()).append(" ").append(event.getMetadata().getName()).append(" ").append(event.getMessage()).append("\n");
            }
            return eventsAsStrBuilder.toString();
        }
    }
}

